/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.baggage;

import com.google.auto.value.AutoValue;
import io.opentelemetry.baggage.AutoValue_Entry;
import io.opentelemetry.baggage.EntryMetadata;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Entry {
    Entry() {
    }

    public static Entry create(String key, String value, EntryMetadata entryMetadata) {
        Utils.checkArgument(Entry.keyIsValid(key), "Invalid entry key name: %s", key);
        Utils.checkArgument(Entry.isValueValid(value), "Invalid entry value: %s", value);
        return new AutoValue_Entry(key, value, entryMetadata);
    }

    public static Entry create(String key, String value) {
        return Entry.create(key, value, EntryMetadata.EMPTY);
    }

    public abstract String getKey();

    public abstract String getValue();

    public abstract EntryMetadata getEntryMetadata();

    private static boolean keyIsValid(String name) {
        return !name.isEmpty() && StringUtils.isPrintableString(name);
    }

    private static boolean isValueValid(String value) {
        return StringUtils.isPrintableString(value);
    }
}

