/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Value;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.ValueType;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ArrayBackedExtendedAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributeType;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

class ArrayBackedExtendedAttributesBuilder
implements ExtendedAttributesBuilder {
    private final List<Object> data;

    ArrayBackedExtendedAttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    ArrayBackedExtendedAttributesBuilder(List<Object> data) {
        this.data = data;
    }

    @Override
    public ExtendedAttributes build() {
        if (this.data.size() == 2 && this.data.get(0) != null) {
            return new ArrayBackedExtendedAttributes(this.data.toArray());
        }
        return ArrayBackedExtendedAttributes.sortAndFilterToAttributes(this.data.toArray());
    }

    @Override
    public <T> ExtendedAttributesBuilder put(ExtendedAttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        if (key.getType() == ExtendedAttributeType.VALUE && value instanceof Value) {
            this.putValue(key, (Value)value);
            return this;
        }
        this.data.add(key);
        this.data.add(value);
        return this;
    }

    private void putValue(ExtendedAttributeKey<?> key, Value<?> valueObj) {
        String keyName = key.getKey();
        switch (valueObj.getType()) {
            case STRING: {
                this.put(ExtendedAttributeKey.stringKey(keyName), (String)valueObj.getValue());
                return;
            }
            case LONG: {
                this.put(ExtendedAttributeKey.longKey(keyName), (Long)valueObj.getValue());
                return;
            }
            case DOUBLE: {
                this.put(ExtendedAttributeKey.doubleKey(keyName), (Double)valueObj.getValue());
                return;
            }
            case BOOLEAN: {
                this.put(ExtendedAttributeKey.booleanKey(keyName), (Boolean)valueObj.getValue());
                return;
            }
            case ARRAY: {
                List arrayValues = (List)valueObj.getValue();
                ExtendedAttributeType attributeType = ArrayBackedExtendedAttributesBuilder.attributeType(arrayValues);
                switch (attributeType) {
                    case STRING_ARRAY: {
                        ArrayList<String> strings = new ArrayList<String>(arrayValues.size());
                        for (Value v : arrayValues) {
                            strings.add((String)v.getValue());
                        }
                        this.put(ExtendedAttributeKey.stringArrayKey(keyName), strings);
                        return;
                    }
                    case LONG_ARRAY: {
                        ArrayList<Long> longs = new ArrayList<Long>(arrayValues.size());
                        for (Value v : arrayValues) {
                            longs.add((Long)v.getValue());
                        }
                        this.put(ExtendedAttributeKey.longArrayKey(keyName), longs);
                        return;
                    }
                    case DOUBLE_ARRAY: {
                        ArrayList<Double> doubles = new ArrayList<Double>(arrayValues.size());
                        for (Value v : arrayValues) {
                            doubles.add((Double)v.getValue());
                        }
                        this.put(ExtendedAttributeKey.doubleArrayKey(keyName), doubles);
                        return;
                    }
                    case BOOLEAN_ARRAY: {
                        ArrayList<Boolean> booleans = new ArrayList<Boolean>(arrayValues.size());
                        for (Value v : arrayValues) {
                            booleans.add((Boolean)v.getValue());
                        }
                        this.put(ExtendedAttributeKey.booleanArrayKey(keyName), booleans);
                        return;
                    }
                    case VALUE: {
                        this.data.add(key);
                        this.data.add(valueObj);
                        return;
                    }
                    case EXTENDED_ATTRIBUTES: {
                        this.data.add(key);
                        this.data.add(valueObj);
                        return;
                    }
                }
                throw new IllegalArgumentException("Unexpected array attribute type: " + (Object)((Object)attributeType));
            }
            case KEY_VALUE_LIST: 
            case BYTES: 
            case EMPTY: {
                this.data.add(key);
                this.data.add(valueObj);
                return;
            }
        }
    }

    private static ExtendedAttributeType attributeType(List<Value<?>> arrayValues) {
        if (arrayValues.isEmpty()) {
            return ExtendedAttributeType.VALUE;
        }
        ValueType elementType = arrayValues.get(0).getType();
        for (Value<?> v : arrayValues) {
            if (v.getType() == elementType) continue;
            return ExtendedAttributeType.VALUE;
        }
        switch (elementType) {
            case STRING: {
                return ExtendedAttributeType.STRING_ARRAY;
            }
            case LONG: {
                return ExtendedAttributeType.LONG_ARRAY;
            }
            case DOUBLE: {
                return ExtendedAttributeType.DOUBLE_ARRAY;
            }
            case BOOLEAN: {
                return ExtendedAttributeType.BOOLEAN_ARRAY;
            }
            case ARRAY: 
            case KEY_VALUE_LIST: 
            case BYTES: 
            case EMPTY: {
                return ExtendedAttributeType.VALUE;
            }
        }
        throw new IllegalArgumentException("Unsupported element type: " + (Object)((Object)elementType));
    }

    @Override
    public ExtendedAttributesBuilder removeIf(Predicate<ExtendedAttributeKey<?>> predicate) {
        if (predicate == null) {
            return this;
        }
        for (int i = 0; i < this.data.size() - 1; i += 2) {
            Object entry = this.data.get(i);
            if (!(entry instanceof ExtendedAttributeKey) || !predicate.test((ExtendedAttributeKey)entry)) continue;
            this.data.set(i, null);
            this.data.set(i + 1, null);
        }
        return this;
    }

    static List<Double> toList(double ... values) {
        Double[] boxed = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Long> toList(long ... values) {
        Long[] boxed = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Boolean> toList(boolean ... values) {
        Boolean[] boxed = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }
}

