/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.service.peer.internal;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.config.internal.DeclarativeConfigUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.net.internal.UrlParser;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.service.peer.internal.AutoValue_ServicePeerResolver_ServiceMatcher;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class ServicePeerResolver {
    private static final PatchLogger logger = PatchLogger.getLogger(ServicePeerResolver.class.getName());
    private static final AttributeKey<String> PEER_SERVICE = AttributeKey.stringKey("peer.service");
    private static final AttributeKey<String> SERVICE_PEER_NAME = AttributeKey.stringKey("service.peer.name");
    private static final AttributeKey<String> SERVICE_PEER_NAMESPACE = AttributeKey.stringKey("service.peer.namespace");
    private static final Comparator<ServiceMatcher> matcherComparator = Comparator.nullsFirst(Comparator.comparing(ServiceMatcher::getPort, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(ServiceMatcher::getPath, Comparator.nullsFirst(Comparator.naturalOrder())));
    private final Map<String, Map<ServiceMatcher, ServicePeer>> servicePeerMapping = new HashMap<String, Map<ServiceMatcher, ServicePeer>>();

    public ServicePeerResolver(OpenTelemetry openTelemetry) {
        DeclarativeConfigUtil.getInstrumentationConfig(openTelemetry, "common").getStructuredList("service_peer_mapping", Collections.emptyList()).forEach(entry -> {
            String peer = entry.getString("peer");
            String serviceName = entry.getString("service_name");
            String serviceNamespace = entry.getString("service_namespace");
            if (peer == null) {
                logger.log(Level.WARNING, "Invalid service_peer_mapping entry - peer is required: {0}", entry);
                return;
            }
            if (serviceName == null && serviceNamespace == null) {
                logger.log(Level.WARNING, "Invalid service_peer_mapping entry - at least one of service_name or service_namespace is required: {0}", entry);
                return;
            }
            this.addMapping(peer, serviceName, serviceNamespace);
        });
    }

    public ServicePeerResolver(Map<String, String> servicePeerNameMapping) {
        servicePeerNameMapping.forEach((peer, serviceName) -> this.addMapping((String)peer, (String)serviceName, null));
    }

    private void addMapping(String peer, @Nullable String serviceName, @Nullable String serviceNamespace) {
        if (serviceName == null && serviceNamespace == null) {
            return;
        }
        ServicePeer info = new ServicePeer(serviceName, serviceNamespace);
        String url = "https://" + peer;
        String host = UrlParser.getHost(url);
        Integer port = UrlParser.getPort(url);
        String path = UrlParser.getPath(url);
        Map matchers = this.servicePeerMapping.computeIfAbsent(host, x -> new HashMap());
        matchers.putIfAbsent(ServiceMatcher.create(port, path), info);
    }

    public boolean isEmpty() {
        return this.servicePeerMapping.isEmpty();
    }

    public void resolve(String host, @Nullable Integer port, Supplier<String> pathSupplier, BiConsumer<AttributeKey<String>, String> attributeSetter) {
        String namespace;
        ServicePeer servicePeer = this.resolveServicePeer(host, port, pathSupplier);
        if (servicePeer == null) {
            return;
        }
        String name = servicePeer.name;
        if (name != null) {
            if (SemconvStability.emitOldServicePeerSemconv()) {
                attributeSetter.accept(PEER_SERVICE, name);
            }
            if (SemconvStability.emitStableServicePeerSemconv()) {
                attributeSetter.accept(SERVICE_PEER_NAME, name);
            }
        }
        if (SemconvStability.emitStableServicePeerSemconv() && (namespace = servicePeer.namespace) != null) {
            attributeSetter.accept(SERVICE_PEER_NAMESPACE, namespace);
        }
    }

    @Nullable
    public String resolveServiceName(String host, @Nullable Integer port, Supplier<String> pathSupplier) {
        ServicePeer peer = this.resolveServicePeer(host, port, pathSupplier);
        return peer != null ? peer.name : null;
    }

    @Nullable
    ServicePeer resolveServicePeer(String host, @Nullable Integer port, Supplier<String> pathSupplier) {
        Map<ServiceMatcher, ServicePeer> matchers = this.servicePeerMapping.get(host);
        if (matchers == null) {
            return null;
        }
        return matchers.entrySet().stream().filter(entry -> ((ServiceMatcher)entry.getKey()).matches(port, pathSupplier)).max((o1, o2) -> matcherComparator.compare((ServiceMatcher)o1.getKey(), (ServiceMatcher)o2.getKey())).map(Map.Entry::getValue).orElse(null);
    }

    public static ServicePeerResolver fromPeerServiceResolver(final PeerServiceResolver resolver) {
        return new ServicePeerResolver(new HashMap()){

            @Override
            public boolean isEmpty() {
                return resolver.isEmpty();
            }

            @Override
            @Nullable
            ServicePeer resolveServicePeer(String host, @Nullable Integer port, Supplier<String> pathSupplier) {
                String serviceName = resolver.resolveService(host, port, pathSupplier);
                return serviceName != null ? new ServicePeer(serviceName, null) : null;
            }
        };
    }

    private static final class ServicePeer {
        @Nullable
        private final String name;
        @Nullable
        private final String namespace;

        ServicePeer(@Nullable String name, @Nullable String namespace) {
            this.name = name;
            this.namespace = namespace;
        }
    }

    @AutoValue
    static abstract class ServiceMatcher {
        ServiceMatcher() {
        }

        static ServiceMatcher create(@Nullable Integer port, @Nullable String path) {
            return new AutoValue_ServicePeerResolver_ServiceMatcher(port, path);
        }

        @Nullable
        abstract Integer getPort();

        @Nullable
        abstract String getPath();

        public boolean matches(@Nullable Integer port, Supplier<String> pathSupplier) {
            if (this.getPort() != null && !this.getPort().equals(port)) {
                return false;
            }
            if (this.getPath() != null && this.getPath().length() > 0) {
                String path = pathSupplier.get();
                if (path == null) {
                    return false;
                }
                if (!path.startsWith(this.getPath())) {
                    return false;
                }
                if (port != null) {
                    return port.equals(this.getPort());
                }
            }
            return true;
        }
    }
}

