/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.service.peer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.service.peer.internal.ServicePeerResolver;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.ServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public final class ServicePeerAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final ServerAttributesGetter<REQUEST> attributesGetter;
    private final ServicePeerResolver servicePeerResolver;

    ServicePeerAttributesExtractor(ServerAttributesGetter<REQUEST> attributesGetter, ServicePeerResolver servicePeerResolver) {
        this.attributesGetter = attributesGetter;
        this.servicePeerResolver = servicePeerResolver;
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(ServerAttributesGetter<REQUEST> attributesGetter, OpenTelemetry openTelemetry) {
        return ServicePeerAttributesExtractor.create(attributesGetter, new ServicePeerResolver(openTelemetry));
    }

    @Deprecated
    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(ServerAttributesGetter<REQUEST> attributesGetter, ServicePeerResolver servicePeerResolver) {
        if (servicePeerResolver.isEmpty()) {
            return new EmptyAttributesExtractor();
        }
        return new ServicePeerAttributesExtractor<REQUEST, RESPONSE>(attributesGetter, servicePeerResolver);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        String serverAddress = this.attributesGetter.getServerAddress(request);
        if (serverAddress == null) {
            return;
        }
        this.servicePeerResolver.resolve(serverAddress, this.attributesGetter.getServerPort(request), () -> null, attributes::put);
    }

    private static final class EmptyAttributesExtractor<REQUEST, RESPONSE>
    implements AttributesExtractor<REQUEST, RESPONSE> {
        private EmptyAttributesExtractor() {
        }

        @Override
        public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        }

        @Override
        public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        }
    }
}

