/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.net.internal.UrlParser;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.service.peer.internal.ServicePeerResolver;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.internal.HostAddressAndPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.AddressAndPort;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.ServerAddressAndPortExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public final class HttpClientServicePeerAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final AddressAndPortExtractor<REQUEST> addressAndPortExtractor;
    private final HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private final ServicePeerResolver servicePeerResolver;

    HttpClientServicePeerAttributesExtractor(AddressAndPortExtractor<REQUEST> addressAndPortExtractor, HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, ServicePeerResolver servicePeerResolver) {
        this.addressAndPortExtractor = addressAndPortExtractor;
        this.attributesGetter = attributesGetter;
        this.servicePeerResolver = servicePeerResolver;
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, OpenTelemetry openTelemetry) {
        return HttpClientServicePeerAttributesExtractor.create(attributesGetter, new ServicePeerResolver(openTelemetry));
    }

    @Deprecated
    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, ServicePeerResolver servicePeerResolver) {
        if (servicePeerResolver.isEmpty()) {
            return new EmptyAttributesExtractor();
        }
        ServerAddressAndPortExtractor<REQUEST> addressAndPortExtractor = new ServerAddressAndPortExtractor<REQUEST>(attributesGetter, new HostAddressAndPortExtractor<REQUEST>(attributesGetter));
        return new HttpClientServicePeerAttributesExtractor<REQUEST, RESPONSE>(addressAndPortExtractor, attributesGetter, servicePeerResolver);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AddressAndPort addressAndPort = this.addressAndPortExtractor.extract(request);
        String host = addressAndPort.getAddress();
        if (host == null) {
            return;
        }
        this.servicePeerResolver.resolve(host, addressAndPort.getPort(), () -> this.getUrlPath(this.attributesGetter, request), attributes::put);
    }

    @Nullable
    private String getUrlPath(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, REQUEST request) {
        String urlFull = attributesGetter.getUrlFull(request);
        if (urlFull == null) {
            return null;
        }
        return UrlParser.getPath(urlFull);
    }

    private static final class EmptyAttributesExtractor<REQUEST, RESPONSE>
    implements AttributesExtractor<REQUEST, RESPONSE> {
        private EmptyAttributesExtractor() {
        }

        @Override
        public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        }

        @Override
        public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        }
    }
}

