/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.AutoSqlSanitizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.AutoSqlSanitizerWithSummary;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.AutoValue_SqlQuerySanitizer_CacheKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlDialect;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.Cache;
import javax.annotation.Nullable;

public final class SqlQuerySanitizer {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private static final Cache<CacheKey, SqlQuery> sqlToQueryCache = Cache.bounded(1000);
    private static final Cache<CacheKey, SqlQuery> sqlToQueryCacheWithSummary = Cache.bounded(1000);
    private static final int LARGE_QUERY_THRESHOLD = 10240;
    private final boolean querySanitizationEnabled;

    public static SqlQuerySanitizer create(boolean querySanitizationEnabled) {
        return new SqlQuerySanitizer(querySanitizationEnabled);
    }

    private SqlQuerySanitizer(boolean querySanitizationEnabled) {
        this.querySanitizationEnabled = querySanitizationEnabled;
    }

    public SqlQuery sanitize(@Nullable String query) {
        return this.sanitize(query, SqlDialect.DEFAULT);
    }

    public SqlQuery sanitize(@Nullable String query, SqlDialect dialect) {
        if (!this.querySanitizationEnabled || query == null) {
            return SqlQuery.create(query, null, null);
        }
        if (query.length() > 10240) {
            return SqlQuerySanitizer.sanitizeImpl(query, dialect);
        }
        return sqlToQueryCache.computeIfAbsent(CacheKey.create(query, dialect), k -> SqlQuerySanitizer.sanitizeImpl(query, dialect));
    }

    private static SqlQuery sanitizeImpl(String query, SqlDialect dialect) {
        supportability.incrementCounter(SupportabilityMetrics.CounterNames.SQL_SANITIZER_CACHE_MISS);
        return AutoSqlSanitizer.sanitize(query, dialect);
    }

    public SqlQuery sanitizeWithSummary(@Nullable String query) {
        return this.sanitizeWithSummary(query, SqlDialect.DEFAULT);
    }

    public SqlQuery sanitizeWithSummary(@Nullable String query, SqlDialect dialect) {
        if (!this.querySanitizationEnabled || query == null) {
            return SqlQuery.createWithSummary(query, null, null);
        }
        if (query.length() > 10240) {
            return SqlQuerySanitizer.sanitizeWithSummaryImpl(query, dialect);
        }
        return sqlToQueryCacheWithSummary.computeIfAbsent(CacheKey.create(query, dialect), k -> SqlQuerySanitizer.sanitizeWithSummaryImpl(query, dialect));
    }

    private static SqlQuery sanitizeWithSummaryImpl(String query, SqlDialect dialect) {
        supportability.incrementCounter(SupportabilityMetrics.CounterNames.SQL_SANITIZER_CACHE_MISS);
        return AutoSqlSanitizerWithSummary.sanitize(query, dialect);
    }

    static boolean isCached(String query) {
        return sqlToQueryCache.get(CacheKey.create(query, SqlDialect.DEFAULT)) != null;
    }

    @AutoValue
    static abstract class CacheKey {
        CacheKey() {
        }

        static CacheKey create(String queryText, SqlDialect dialect) {
            return new AutoValue_SqlQuerySanitizer_CacheKey(queryText, dialect);
        }

        abstract String getQueryText();

        abstract SqlDialect getDialect();
    }
}

