/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.AutoValue_SqlQuery;
import javax.annotation.Nullable;

@AutoValue
public abstract class SqlQuery {
    private static final String SQL_CALL = "CALL";
    private static final int QUERY_SUMMARY_MAX_LENGTH = 255;

    public static SqlQuery createWithSummary(@Nullable String queryText, @Nullable String storedProcedureName, @Nullable String querySummary) {
        String truncatedQuerySummary = SqlQuery.truncateQuerySummary(querySummary);
        return new AutoValue_SqlQuery(queryText, null, null, storedProcedureName, truncatedQuerySummary);
    }

    public static SqlQuery create(@Nullable String queryText, @Nullable String operationName, @Nullable String target) {
        boolean isStoredProcedure = SQL_CALL.equals(operationName) || "EXECUTE".equals(operationName);
        String collectionName = isStoredProcedure ? null : target;
        String storedProcedureName = isStoredProcedure ? target : null;
        return new AutoValue_SqlQuery(queryText, operationName, collectionName, storedProcedureName, null);
    }

    @Nullable
    private static String truncateQuerySummary(@Nullable String querySummary) {
        if (querySummary == null || querySummary.length() <= 255) {
            return querySummary;
        }
        int lastSpace = querySummary.lastIndexOf(32, 255);
        if (lastSpace > 0) {
            return querySummary.substring(0, lastSpace);
        }
        return querySummary.substring(0, 255);
    }

    @Nullable
    public abstract String getQueryText();

    @Nullable
    public abstract String getOperationName();

    @Nullable
    public abstract String getCollectionName();

    @Nullable
    public abstract String getStoredProcedureName();

    @Nullable
    public abstract String getQuerySummary();
}

