/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.MultiQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlQuerySanitizerUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.internal.ExtractQuerySummaryMarker;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.ServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.DbAttributes;
import java.util.Collection;
import javax.annotation.Nullable;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    private final SqlClientAttributesGetter<REQUEST, RESPONSE> getter;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final ServerAttributesExtractor<REQUEST, RESPONSE> serverAttributesExtractor;
    private final AttributeKey<String> oldSemconvTableAttribute;
    private final boolean querySanitizationEnabled;
    private final boolean captureQueryParameters;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST, RESPONSE> getter, AttributeKey<String> oldSemconvTableAttribute, boolean querySanitizationEnabled, boolean captureQueryParameters) {
        this.getter = getter;
        this.oldSemconvTableAttribute = oldSemconvTableAttribute;
        this.querySanitizationEnabled = !captureQueryParameters && querySanitizationEnabled;
        this.captureQueryParameters = captureQueryParameters;
        this.internalNetworkExtractor = new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(getter, true, false);
        this.serverAttributesExtractor = ServerAttributesExtractor.create(getter);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        boolean isBatch;
        Collection<String> rawQueryTexts = this.getter.getRawQueryTexts(request);
        Long batchSize = this.getter.getDbOperationBatchSize(request);
        boolean bl = isBatch = batchSize != null && batchSize > 1L;
        if (SemconvStability.emitOldDatabaseSemconv() && rawQueryTexts.size() == 1) {
            String rawQueryText = rawQueryTexts.iterator().next();
            SqlQuery sanitizedQuery = SqlQuerySanitizerUtil.sanitize(rawQueryText);
            String operationName = sanitizedQuery.getOperationName();
            AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, this.querySanitizationEnabled ? sanitizedQuery.getQueryText() : rawQueryText);
            AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, operationName);
            AttributesExtractorUtil.internalSet(attributes, this.oldSemconvTableAttribute, sanitizedQuery.getCollectionName());
        }
        if (SemconvStability.emitStableDatabaseSemconv()) {
            boolean shouldSanitize;
            if (isBatch) {
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_OPERATION_BATCH_SIZE, batchSize);
            }
            boolean parameterizedQuery = this.getter.isParameterizedQuery(request);
            boolean bl2 = shouldSanitize = this.querySanitizationEnabled && !parameterizedQuery;
            if (rawQueryTexts.size() == 1) {
                String rawQueryText = rawQueryTexts.iterator().next();
                SqlQuery sanitizedQuery = this.getter instanceof ExtractQuerySummaryMarker ? SqlQuerySanitizerUtil.sanitizeWithSummary(rawQueryText) : SqlQuerySanitizerUtil.sanitize(rawQueryText);
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_TEXT, shouldSanitize ? sanitizedQuery.getQueryText() : rawQueryText);
                String querySummary = sanitizedQuery.getQuerySummary();
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_SUMMARY, isBatch && querySummary != null ? "BATCH " + querySummary : querySummary);
                if (!(this.getter instanceof ExtractQuerySummaryMarker)) {
                    String operationName = sanitizedQuery.getOperationName();
                    AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_OPERATION_NAME, isBatch ? "BATCH " + operationName : operationName);
                }
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_COLLECTION_NAME, sanitizedQuery.getCollectionName());
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_STORED_PROCEDURE_NAME, sanitizedQuery.getStoredProcedureName());
            } else if (rawQueryTexts.size() > 1) {
                MultiQuery multiQuery = this.getter instanceof ExtractQuerySummaryMarker ? MultiQuery.analyzeWithSummary(this.getter.getRawQueryTexts(request), shouldSanitize) : MultiQuery.analyze(this.getter.getRawQueryTexts(request), shouldSanitize);
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_TEXT, SqlClientAttributesExtractor.join("; ", multiQuery.getQueryTexts()));
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_SUMMARY, multiQuery.getQuerySummary());
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_OPERATION_NAME, multiQuery.getOperationName());
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_COLLECTION_NAME, multiQuery.getCollectionName());
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_STORED_PROCEDURE_NAME, multiQuery.getStoredProcedureName());
            }
        }
        DbClientAttributesExtractor.onStartCommon(attributes, this.getter, request, this.captureQueryParameters);
        this.serverAttributesExtractor.onStart(attributes, parentContext, request);
    }

    private static String join(String delimiter, Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        for (String string : collection) {
            if (builder.length() != 0) {
                builder.append(delimiter);
            }
            builder.append(string);
        }
        return builder.toString();
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.internalNetworkExtractor.onEnd(attributes, request, response);
        DbClientAttributesExtractor.onEndCommon(attributes, this.getter, response, error);
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

