/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlQuerySanitizerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

class MultiQuery {
    @Nullable
    private final String collectionName;
    @Nullable
    private final String storedProcedureName;
    @Nullable
    private final String operationName;
    private final Set<String> queryTexts;
    @Nullable
    private final String querySummary;

    private MultiQuery(@Nullable String collectionName, @Nullable String storedProcedureName, @Nullable String operationName, Set<String> queryTexts, @Nullable String querySummary) {
        this.collectionName = collectionName;
        this.storedProcedureName = storedProcedureName;
        this.operationName = operationName;
        this.queryTexts = queryTexts;
        this.querySummary = querySummary;
    }

    static MultiQuery analyze(Collection<String> rawQueryTexts, boolean querySanitizationEnabled) {
        return MultiQuery.analyzeInternal(rawQueryTexts, querySanitizationEnabled, false);
    }

    static MultiQuery analyzeWithSummary(Collection<String> rawQueryTexts, boolean querySanitizationEnabled) {
        return MultiQuery.analyzeInternal(rawQueryTexts, querySanitizationEnabled, true);
    }

    private static MultiQuery analyzeInternal(Collection<String> rawQueryTexts, boolean querySanitizationEnabled, boolean withSummary) {
        UniqueValue uniqueCollectionName = new UniqueValue();
        UniqueValue uniqueStoredProcedureName = new UniqueValue();
        UniqueValue uniqueOperationName = new UniqueValue();
        LinkedHashSet<String> uniqueQueryTexts = new LinkedHashSet<String>();
        UniqueValue uniqueQuerySummary = new UniqueValue();
        for (String rawQueryText : rawQueryTexts) {
            SqlQuery sanitizedQuery = withSummary ? SqlQuerySanitizerUtil.sanitizeWithSummary(rawQueryText) : SqlQuerySanitizerUtil.sanitize(rawQueryText);
            String collectionName = sanitizedQuery.getCollectionName();
            uniqueCollectionName.set(collectionName);
            String storedProcedureName = sanitizedQuery.getStoredProcedureName();
            uniqueStoredProcedureName.set(storedProcedureName);
            String operationName = sanitizedQuery.getOperationName();
            uniqueOperationName.set(operationName);
            uniqueQueryTexts.add(querySanitizationEnabled ? sanitizedQuery.getQueryText() : rawQueryText);
            uniqueQuerySummary.set(sanitizedQuery.getQuerySummary());
        }
        String operationName = uniqueOperationName.getValue();
        String querySummary = uniqueQuerySummary.getValue();
        return new MultiQuery(uniqueCollectionName.getValue(), uniqueStoredProcedureName.getValue(), withSummary ? null : (operationName == null ? "BATCH" : "BATCH " + operationName), uniqueQueryTexts, withSummary ? (querySummary == null ? "BATCH" : "BATCH " + querySummary) : null);
    }

    @Nullable
    public String getCollectionName() {
        return this.collectionName;
    }

    @Nullable
    public String getStoredProcedureName() {
        return this.storedProcedureName;
    }

    @Nullable
    public String getOperationName() {
        return this.operationName;
    }

    @Nullable
    public String getQuerySummary() {
        return this.querySummary;
    }

    public Set<String> getQueryTexts() {
        return this.queryTexts;
    }

    private static class UniqueValue {
        @Nullable
        private String value;
        private boolean valid = true;

        private UniqueValue() {
        }

        void set(@Nullable String value) {
            if (!this.valid) {
                return;
            }
            if (this.value == null) {
                this.value = value;
            } else if (!this.value.equals(value)) {
                this.valid = false;
            }
        }

        @Nullable
        String getValue() {
            return this.valid ? this.value : null;
        }
    }
}

