/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.MultiQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlQuerySanitizerUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.internal.ExtractQuerySummaryMarker;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class DbClientSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private static final String DEFAULT_SPAN_NAME = "DB Query";

    public static <REQUEST> SpanNameExtractor<REQUEST> create(DbClientAttributesGetter<REQUEST, ?> getter) {
        return new GenericDbClientSpanNameExtractor(getter);
    }

    public static <REQUEST> SpanNameExtractor<REQUEST> create(SqlClientAttributesGetter<REQUEST, ?> getter) {
        return new SqlClientSpanNameExtractor(getter);
    }

    private DbClientSpanNameExtractor() {
    }

    protected String computeSpanName(@Nullable String namespace, @Nullable String operationName, @Nullable String collectionName, @Nullable String storedProcedureName) {
        String mainIdentifier;
        if (operationName == null) {
            return namespace == null ? DEFAULT_SPAN_NAME : namespace;
        }
        StringBuilder spanName = new StringBuilder(operationName);
        String string = mainIdentifier = collectionName != null ? collectionName : storedProcedureName;
        if (namespace != null || mainIdentifier != null) {
            spanName.append(' ');
        }
        if (namespace != null && (mainIdentifier == null || mainIdentifier.indexOf(46) == -1)) {
            spanName.append(namespace);
            if (mainIdentifier != null) {
                spanName.append('.');
            }
        }
        if (mainIdentifier != null) {
            spanName.append(mainIdentifier);
        }
        return spanName.toString();
    }

    protected String computeSpanNameStable(DbClientAttributesGetter<REQUEST, ?> getter, REQUEST request, @Nullable String operation, @Nullable String collectionName, @Nullable String storedProcedureName) {
        String serverAddress;
        String target = collectionName;
        if (target == null) {
            target = storedProcedureName;
        }
        if (target == null) {
            target = getter.getDbNamespace(request);
        }
        if (target == null && (serverAddress = getter.getServerAddress(request)) != null) {
            Integer serverPort = getter.getServerPort(request);
            target = serverPort != null ? serverAddress + ":" + serverPort : serverAddress;
        }
        if (operation != null) {
            if (target != null) {
                return operation + " " + target;
            }
            return operation;
        }
        if (target != null) {
            return target;
        }
        String dbSystem = getter.getDbSystemName(request);
        return dbSystem != null ? dbSystem : DEFAULT_SPAN_NAME;
    }

    private static final class GenericDbClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private final DbClientAttributesGetter<REQUEST, ?> getter;

        private GenericDbClientSpanNameExtractor(DbClientAttributesGetter<REQUEST, ?> getter) {
            this.getter = getter;
        }

        @Override
        public String extract(REQUEST request) {
            if (SemconvStability.emitStableDatabaseSemconv()) {
                String querySummary = this.getter.getDbQuerySummary(request);
                if (querySummary != null) {
                    return querySummary;
                }
                String operationName = this.getter.getDbOperationName(request);
                return this.computeSpanNameStable(this.getter, request, operationName, null, null);
            }
            String namespace = this.getter.getDbNamespace(request);
            String operationName = this.getter.getDbOperationName(request);
            return this.computeSpanName(namespace, operationName, null, null);
        }
    }

    private static final class SqlClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private final SqlClientAttributesGetter<REQUEST, ?> getter;

        private SqlClientSpanNameExtractor(SqlClientAttributesGetter<REQUEST, ?> getter) {
            this.getter = getter;
        }

        @Override
        public String extract(REQUEST request) {
            String namespace = this.getter.getDbNamespace(request);
            Collection<String> rawQueryTexts = this.getter.getRawQueryTexts(request);
            if (rawQueryTexts.isEmpty()) {
                if (SemconvStability.emitStableDatabaseSemconv()) {
                    return this.computeSpanNameStable(this.getter, request, null, null, null);
                }
                return this.computeSpanName(namespace, null, null, null);
            }
            if (!SemconvStability.emitStableDatabaseSemconv()) {
                if (rawQueryTexts.size() > 1) {
                    return this.computeSpanName(namespace, null, null, null);
                }
                SqlQuery sanitizedQuery = SqlQuerySanitizerUtil.sanitize(rawQueryTexts.iterator().next());
                return this.computeSpanName(namespace, sanitizedQuery.getOperationName(), sanitizedQuery.getCollectionName(), sanitizedQuery.getStoredProcedureName());
            }
            if (rawQueryTexts.size() == 1) {
                String rawQueryText = rawQueryTexts.iterator().next();
                SqlQuery sanitizedQuery = this.getter instanceof ExtractQuerySummaryMarker ? SqlQuerySanitizerUtil.sanitizeWithSummary(rawQueryText) : SqlQuerySanitizerUtil.sanitize(rawQueryText);
                boolean batch = this.isBatch(request);
                String querySummary = sanitizedQuery.getQuerySummary();
                if (querySummary != null) {
                    return batch ? "BATCH " + querySummary : querySummary;
                }
                String operationName = sanitizedQuery.getOperationName();
                if (batch) {
                    operationName = operationName == null ? "BATCH" : "BATCH " + operationName;
                }
                return this.computeSpanNameStable(this.getter, request, operationName, sanitizedQuery.getCollectionName(), sanitizedQuery.getStoredProcedureName());
            }
            MultiQuery multiQuery = this.getter instanceof ExtractQuerySummaryMarker ? MultiQuery.analyzeWithSummary(rawQueryTexts, false) : MultiQuery.analyze(rawQueryTexts, false);
            String querySummary = multiQuery.getQuerySummary();
            if (querySummary != null) {
                return querySummary;
            }
            return this.computeSpanNameStable(this.getter, request, multiQuery.getOperationName(), multiQuery.getCollectionName(), multiQuery.getStoredProcedureName());
        }

        private boolean isBatch(REQUEST request) {
            Long batchSize = this.getter.getDbOperationBatchSize(request);
            return batchSize != null && batchSize > 1L;
        }
    }
}

