/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.InternalLogger;
import io.opentelemetry.javaagent.bootstrap.NoopLoggerFactory;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class InternalLoggerFactoryHolder {
    private static final AtomicReference<InternalLogger.Factory> loggerFactory = new AtomicReference<InternalLogger.Factory>(NoopLoggerFactory.INSTANCE);

    static void initialize(InternalLogger.Factory factory) {
        if (!loggerFactory.compareAndSet(NoopLoggerFactory.INSTANCE, factory)) {
            factory.create(InternalLogger.class.getName()).log(InternalLogger.Level.WARN, "Developer error: logging system has already been initialized once", null);
        }
    }

    static InternalLogger.Factory get() {
        return Objects.requireNonNull(loggerFactory.get());
    }

    private InternalLoggerFactoryHolder() {
    }
}

