/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementSanitizerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

class MultiQuery {
    @Nullable
    private final String collectionName;
    @Nullable
    private final String storedProcedureName;
    private final String operationName;
    private final Set<String> queryTexts;

    private MultiQuery(@Nullable String collectionName, @Nullable String storedProcedureName, String operationName, Set<String> queryTexts) {
        this.collectionName = collectionName;
        this.storedProcedureName = storedProcedureName;
        this.operationName = operationName;
        this.queryTexts = queryTexts;
    }

    static MultiQuery analyze(Collection<String> rawQueryTexts, boolean statementSanitizationEnabled) {
        UniqueValue uniqueCollectionName = new UniqueValue();
        UniqueValue uniqueStoredProcedureName = new UniqueValue();
        UniqueValue uniqueOperationName = new UniqueValue();
        LinkedHashSet<String> uniqueQueryTexts = new LinkedHashSet<String>();
        for (String rawQueryText : rawQueryTexts) {
            SqlStatementInfo sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
            String collectionName = sanitizedStatement.getCollectionName();
            uniqueCollectionName.set(collectionName);
            String storedProcedureName = sanitizedStatement.getStoredProcedureName();
            uniqueStoredProcedureName.set(storedProcedureName);
            String operationName = sanitizedStatement.getOperationName();
            uniqueOperationName.set(operationName);
            uniqueQueryTexts.add(statementSanitizationEnabled ? sanitizedStatement.getQueryText() : rawQueryText);
        }
        String operationName = uniqueOperationName.getValue();
        return new MultiQuery(uniqueCollectionName.getValue(), uniqueStoredProcedureName.getValue(), operationName == null ? "BATCH" : "BATCH " + operationName, uniqueQueryTexts);
    }

    @Nullable
    public String getCollectionName() {
        return this.collectionName;
    }

    @Nullable
    public String getStoredProcedureName() {
        return this.storedProcedureName;
    }

    @Deprecated
    @Nullable
    public String getMainIdentifier() {
        return this.collectionName != null ? this.collectionName : this.storedProcedureName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    @Deprecated
    @Nullable
    public String getOperation() {
        return this.getOperationName();
    }

    public Set<String> getQueryTexts() {
        return this.queryTexts;
    }

    @Deprecated
    public Set<String> getStatements() {
        return this.getQueryTexts();
    }

    private static class UniqueValue {
        @Nullable
        private String value;
        private boolean valid = true;

        private UniqueValue() {
        }

        void set(@Nullable String value) {
            if (!this.valid) {
                return;
            }
            if (this.value == null) {
                this.value = value;
            } else if (!this.value.equals(value)) {
                this.valid = false;
            }
        }

        @Nullable
        String getValue() {
            return this.valid ? this.value : null;
        }
    }
}

