/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

final class CapturedHttpHeadersUtil {
    private static final ConcurrentMap<String, AttributeKey<List<String>>> requestKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();
    private static final ConcurrentMap<String, AttributeKey<List<String>>> responseKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();

    static List<String> lowercase(List<String> names) {
        return Collections.unmodifiableList(names.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList()));
    }

    static AttributeKey<List<String>> requestAttributeKey(String headerName) {
        return requestKeysCache.computeIfAbsent(headerName, n -> CapturedHttpHeadersUtil.createKey("request", n));
    }

    static AttributeKey<List<String>> responseAttributeKey(String headerName) {
        return responseKeysCache.computeIfAbsent(headerName, n -> CapturedHttpHeadersUtil.createKey("response", n));
    }

    private static AttributeKey<List<String>> createKey(String type, String headerName) {
        String key = "http." + type + ".header." + headerName;
        return AttributeKey.stringArrayKey(key);
    }

    private CapturedHttpHeadersUtil() {
    }
}

