/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.internal;

import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import java.util.Collections;
import java.util.List;

public final class ExperimentalConfig {
    private static final ExperimentalConfig instance = new ExperimentalConfig(InstrumentationConfig.get());
    private final InstrumentationConfig config;
    private final List<String> messagingHeaders;

    public static ExperimentalConfig get() {
        return instance;
    }

    public ExperimentalConfig(InstrumentationConfig config) {
        this.config = config;
        this.messagingHeaders = config.getList("otel.instrumentation.messaging.experimental.capture-headers", Collections.emptyList());
    }

    public boolean controllerTelemetryEnabled() {
        return this.config.getBoolean("otel.instrumentation.common.experimental.controller-telemetry.enabled", false);
    }

    public boolean viewTelemetryEnabled() {
        return this.config.getBoolean("otel.instrumentation.common.experimental.view-telemetry.enabled", false);
    }

    public boolean messagingReceiveInstrumentationEnabled() {
        return this.config.getBoolean("otel.instrumentation.messaging.experimental.receive-telemetry.enabled", false);
    }

    public boolean indyEnabled() {
        return this.config.getBoolean("otel.javaagent.experimental.indy", false);
    }

    public List<String> getMessagingHeaders() {
        return this.messagingHeaders;
    }
}

