/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.HttpStatusConverter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class HttpSpanStatusExtractor<REQUEST, RESPONSE>
implements SpanStatusExtractor<REQUEST, RESPONSE> {
    private final HttpAttributesExtractor<REQUEST, RESPONSE> attributesExtractor;

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpAttributesExtractor<REQUEST, RESPONSE> attributesExtractor) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(attributesExtractor);
    }

    private HttpSpanStatusExtractor(HttpAttributesExtractor<REQUEST, RESPONSE> attributesExtractor) {
        this.attributesExtractor = attributesExtractor;
    }

    @Override
    public StatusCode extract(REQUEST request, @Nullable RESPONSE response, Throwable error) {
        StatusCode statusCodeObj;
        Integer statusCode;
        if (response != null && (statusCode = this.attributesExtractor.statusCode(request, response)) != null && (statusCodeObj = HttpStatusConverter.statusFromHttpStatus(statusCode)) == StatusCode.ERROR) {
            return statusCodeObj;
        }
        return SpanStatusExtractor.getDefault().extract(request, response, error);
    }
}

