/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

public final class ClassNames {
    private static final ClassValue<String> simpleNames = new ClassValue<String>(){

        @Override
        protected String computeValue(Class<?> type) {
            String pkgName;
            if (!type.isAnonymousClass()) {
                return type.getSimpleName();
            }
            String className = type.getName();
            if (type.getPackage() != null && !(pkgName = type.getPackage().getName()).isEmpty()) {
                className = className.substring(pkgName.length() + 1);
            }
            return className;
        }
    };

    public static String simpleName(Class<?> type) {
        return simpleNames.get(type);
    }

    private ClassNames() {
    }
}

