/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.AlternateUrlSchemeProvider;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.ClientAddressAndPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpAddressPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpNetworkTransportFilter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerRoute;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.ServerSideServerPortCondition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.InternalNetServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.url.internal.InternalUrlAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.HttpConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public final class HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter;
    final NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter;
    final HttpAddressPortExtractor<REQUEST> addressPortExtractor;
    List<String> capturedRequestHeaders = Collections.emptyList();
    List<String> capturedResponseHeaders = Collections.emptyList();
    Set<String> knownMethods = HttpConstants.KNOWN_METHODS;
    Function<Context, String> httpRouteGetter = HttpServerRoute::get;

    HttpServerAttributesExtractorBuilder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        this.httpAttributesGetter = httpAttributesGetter;
        this.netAttributesGetter = netAttributesGetter;
        this.addressPortExtractor = new HttpAddressPortExtractor<REQUEST>(httpAttributesGetter);
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedRequestHeaders = new ArrayList<String>(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedResponseHeaders = new ArrayList<String>(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setKnownMethods(Set<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setHttpRouteGetter(Function<Context, String> httpRouteGetter) {
        this.httpRouteGetter = httpRouteGetter;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpServerAttributesExtractor(this);
    }

    InternalUrlAttributesExtractor<REQUEST> buildUrlExtractor() {
        return new InternalUrlAttributesExtractor(this.httpAttributesGetter, new AlternateUrlSchemeProvider<REQUEST>(this.httpAttributesGetter), SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
    }

    InternalNetServerAttributesExtractor<REQUEST, RESPONSE> buildNetExtractor() {
        return new InternalNetServerAttributesExtractor<REQUEST, RESPONSE>(this.netAttributesGetter, this.addressPortExtractor, SemconvStability.emitOldHttpSemconv());
    }

    InternalNetworkAttributesExtractor<REQUEST, RESPONSE> buildNetworkExtractor() {
        return new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(this.netAttributesGetter, HttpNetworkTransportFilter.INSTANCE, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
    }

    InternalServerAttributesExtractor<REQUEST, RESPONSE> buildServerExtractor() {
        return new InternalServerAttributesExtractor<REQUEST, RESPONSE>(this.netAttributesGetter, new ServerSideServerPortCondition<REQUEST>(this.httpAttributesGetter), this.addressPortExtractor, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv(), InternalServerAttributesExtractor.Mode.HOST, false);
    }

    InternalClientAttributesExtractor<REQUEST, RESPONSE> buildClientExtractor() {
        return new InternalClientAttributesExtractor<REQUEST, RESPONSE>(this.netAttributesGetter, new ClientAddressAndPortExtractor<REQUEST>(this.httpAttributesGetter), SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
    }
}

