/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;
import java.util.logging.Level;

final class HttpAddressPortExtractor<REQUEST>
implements FallbackAddressPortExtractor<REQUEST> {
    private static final PatchLogger logger = PatchLogger.getLogger(HttpCommonAttributesGetter.class.getName());
    private final HttpCommonAttributesGetter<REQUEST, ?> getter;

    HttpAddressPortExtractor(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public void extract(FallbackAddressPortExtractor.AddressPortSink sink, REQUEST request) {
        String host = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "host"));
        if (host == null) {
            return;
        }
        int hostHeaderSeparator = host.indexOf(58);
        if (hostHeaderSeparator == -1) {
            sink.setAddress(host);
            return;
        }
        sink.setAddress(host.substring(0, hostHeaderSeparator));
        try {
            sink.setPort(Integer.parseInt(host.substring(hostHeaderSeparator + 1)));
        }
        catch (NumberFormatException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }
}

