/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.FallbackNamePortGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

public final class InternalNetClientAttributesExtractor<REQUEST, RESPONSE> {
    private final NetClientAttributesGetter<REQUEST, RESPONSE> getter;
    private final BiPredicate<Integer, REQUEST> capturePeerPortCondition;
    private final FallbackNamePortGetter<REQUEST> fallbackNamePortGetter;

    public InternalNetClientAttributesExtractor(NetClientAttributesGetter<REQUEST, RESPONSE> getter, BiPredicate<Integer, REQUEST> capturePeerPortCondition, FallbackNamePortGetter<REQUEST> fallbackNamePortGetter) {
        this.getter = getter;
        this.capturePeerPortCondition = capturePeerPortCondition;
        this.fallbackNamePortGetter = fallbackNamePortGetter;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        String peerName = this.extractPeerName(request);
        if (peerName != null) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PEER_NAME, peerName);
            Integer peerPort = this.extractPeerPort(request);
            if (peerPort != null && peerPort > 0 && this.capturePeerPortCondition.test(peerPort, request)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PEER_PORT, Long.valueOf(peerPort.intValue()));
            }
        }
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_TRANSPORT, this.getter.transport(request, response));
        String peerName = this.extractPeerName(request);
        String sockPeerAddr = this.getter.sockPeerAddr(request, response);
        if (sockPeerAddr != null && !sockPeerAddr.equals(peerName)) {
            String sockPeerName;
            String sockFamily;
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_ADDR, sockPeerAddr);
            Integer peerPort = this.extractPeerPort(request);
            Integer sockPeerPort = this.getter.sockPeerPort(request, response);
            if (sockPeerPort != null && sockPeerPort > 0 && !sockPeerPort.equals(peerPort)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_PORT, Long.valueOf(sockPeerPort.intValue()));
            }
            if ((sockFamily = this.getter.sockFamily(request, response)) != null && !sockFamily.equals("inet")) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_FAMILY, sockFamily);
            }
            if ((sockPeerName = this.getter.sockPeerName(request, response)) != null && !sockPeerName.equals(peerName)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_NAME, sockPeerName);
            }
        }
    }

    private String extractPeerName(REQUEST request) {
        String peerName = this.getter.peerName(request);
        if (peerName == null) {
            peerName = this.fallbackNamePortGetter.name(request);
        }
        return peerName;
    }

    private Integer extractPeerPort(REQUEST request) {
        Integer peerPort = this.getter.peerPort(request);
        if (peerPort == null) {
            peerPort = this.fallbackNamePortGetter.port(request);
        }
        return peerPort;
    }
}

