/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenTelemetryAgent {
    private static final Class<?> thisClass = OpenTelemetryAgent.class;

    public static void premain(String agentArgs, Instrumentation inst) {
        OpenTelemetryAgent.agentmain(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        try {
            URL bootstrapUrl = OpenTelemetryAgent.installBootstrapJar(inst);
            Class<?> agentInitializerClass = ClassLoader.getSystemClassLoader().loadClass("io.opentelemetry.javaagent.bootstrap.AgentInitializer");
            Method startMethod = agentInitializerClass.getMethod("initialize", Instrumentation.class, URL.class);
            startMethod.invoke(null, inst, bootstrapUrl);
        }
        catch (Throwable ex) {
            System.err.println("ERROR " + thisClass.getName());
            ex.printStackTrace();
        }
    }

    private static synchronized URL installBootstrapJar(Instrumentation inst) throws IOException, URISyntaxException {
        File bootstrapFile;
        URL javaAgentJarUrl = null;
        CodeSource codeSource = thisClass.getProtectionDomain().getCodeSource();
        if (codeSource != null && !(bootstrapFile = new File((javaAgentJarUrl = codeSource.getLocation()).toURI())).isDirectory()) {
            JarFile agentJar = new JarFile(bootstrapFile, false);
            OpenTelemetryAgent.checkJarManifestMainClassIsThis(javaAgentJarUrl, agentJar);
            inst.appendToBootstrapClassLoaderSearch(agentJar);
            return javaAgentJarUrl;
        }
        System.out.println("Could not get bootstrap jar from code source, using -javaagent arg");
        List<String> arguments = OpenTelemetryAgent.getVmArgumentsThroughReflection();
        String agentArgument = null;
        for (String arg : arguments) {
            if (!arg.startsWith("-javaagent")) continue;
            if (agentArgument == null) {
                agentArgument = arg;
                continue;
            }
            throw new RuntimeException("Multiple javaagents specified and code source unavailable, not installing tracing agent");
        }
        if (agentArgument == null) {
            throw new RuntimeException("Could not find javaagent parameter and code source unavailable, not installing tracing agent");
        }
        Matcher matcher = Pattern.compile("-javaagent:([^=]+).*").matcher(agentArgument);
        if (!matcher.matches()) {
            throw new RuntimeException("Unable to parse javaagent parameter: " + agentArgument);
        }
        File javaagentFile = new File(matcher.group(1));
        if (!javaagentFile.exists() && !javaagentFile.isFile()) {
            throw new RuntimeException("Unable to find javaagent file: " + javaagentFile);
        }
        javaAgentJarUrl = javaagentFile.toURI().toURL();
        JarFile agentJar = new JarFile(javaagentFile, false);
        OpenTelemetryAgent.checkJarManifestMainClassIsThis(javaAgentJarUrl, agentJar);
        inst.appendToBootstrapClassLoaderSearch(agentJar);
        return javaAgentJarUrl;
    }

    private static List<String> getVmArgumentsThroughReflection() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            Object vmManagement;
            Class<?> managementFactoryHelperClass = classLoader.loadClass("sun.management.ManagementFactoryHelper");
            Class<?> vmManagementClass = classLoader.loadClass("sun.management.VMManagement");
            try {
                vmManagement = managementFactoryHelperClass.getDeclaredMethod("getVMManagement", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Field field = managementFactoryHelperClass.getDeclaredField("jvm");
                field.setAccessible(true);
                vmManagement = field.get(null);
                field.setAccessible(false);
            }
            return (List)vmManagementClass.getMethod("getVmArguments", new Class[0]).invoke(vmManagement, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            try {
                Class<?> vmClass = classLoader.loadClass("com.ibm.oti.vm.VM");
                String[] argArray = (String[])vmClass.getMethod("getVMArgs", new Class[0]).invoke(null, new Object[0]);
                return Arrays.asList(argArray);
            }
            catch (ReflectiveOperationException e1) {
                System.out.println("WARNING: Unable to get VM args through reflection.  A custom java.util.logging.LogManager may not work correctly");
                return ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
        }
    }

    private static boolean checkJarManifestMainClassIsThis(URL jarUrl, JarFile agentJar) throws IOException {
        Manifest manifest = agentJar.getManifest();
        String mainClass = manifest.getMainAttributes().getValue("Main-Class");
        if (thisClass.getCanonicalName().equals(mainClass)) {
            return true;
        }
        throw new RuntimeException("opentelemetry-javaagent is not installed, because class '" + thisClass.getCanonicalName() + "' is located in '" + jarUrl + "'. Make sure you don't have this .class file anywhere, besides opentelemetry-javaagent.jar");
    }

    public static void main(String ... args) {
        try {
            System.out.println(OpenTelemetryAgent.class.getPackage().getImplementationVersion());
        }
        catch (Exception e) {
            System.out.println("Failed to parse agent version");
            e.printStackTrace();
        }
    }
}

