/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class NetClientAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final NetClientAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> NetClientAttributesExtractor<REQUEST, RESPONSE> create(NetClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new NetClientAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private NetClientAttributesExtractor(NetClientAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_TRANSPORT, this.getter.transport(request, response));
        String peerIp = this.getter.peerIp(request, response);
        String peerName = this.getter.peerName(request, response);
        if (peerName != null && !peerName.equals(peerIp)) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PEER_NAME, peerName);
        }
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PEER_IP, peerIp);
        Integer peerPort = this.getter.peerPort(request, response);
        if (peerPort != null && peerPort > 0) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PEER_PORT, Long.valueOf(peerPort.intValue()));
        }
    }
}

