/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.ArrayBasedTraceState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceStateBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class ArrayBasedTraceStateBuilder
implements TraceStateBuilder {
    private static final int MAX_VENDOR_ID_SIZE = 13;
    private static final ArrayBasedTraceState EMPTY = ArrayBasedTraceState.create(Collections.emptyList());
    private static final int MAX_KEY_VALUE_PAIRS = 32;
    private static final int KEY_MAX_SIZE = 256;
    private static final int VALUE_MAX_SIZE = 256;
    private static final int MAX_TENANT_ID_SIZE = 240;
    private final ArrayBasedTraceState parent;
    @Nullable
    private List<String> entries;

    static TraceState empty() {
        return EMPTY;
    }

    ArrayBasedTraceStateBuilder() {
        this.parent = EMPTY;
    }

    ArrayBasedTraceStateBuilder(ArrayBasedTraceState parent) {
        this.parent = parent;
    }

    @Override
    public TraceStateBuilder put(String key, String value) {
        if (!ArrayBasedTraceStateBuilder.isKeyValid(key) || !ArrayBasedTraceStateBuilder.isValueValid(value) || this.entries != null && this.entries.size() >= 32) {
            return this;
        }
        if (this.entries == null) {
            this.entries = new ArrayList<String>(this.parent.getEntries());
        }
        this.removeEntry(key);
        this.entries.add(0, key);
        this.entries.add(1, value);
        return this;
    }

    @Override
    public TraceStateBuilder remove(String key) {
        if (key == null) {
            return this;
        }
        if (this.entries == null) {
            this.entries = new ArrayList<String>(this.parent.getEntries());
        }
        this.removeEntry(key);
        return this;
    }

    private void removeEntry(String key) {
        int currentSize = this.entries.size();
        for (int i = 0; i < currentSize; i += 2) {
            if (!this.entries.get(i).equals(key)) continue;
            this.entries.remove(i);
            this.entries.remove(i);
            break;
        }
    }

    @Override
    public TraceState build() {
        if (this.entries == null) {
            return this.parent;
        }
        return ArrayBasedTraceState.create(this.entries);
    }

    private static boolean isKeyValid(@Nullable String key) {
        if (key == null) {
            return false;
        }
        if (key.length() > 256 || key.isEmpty() || ArrayBasedTraceStateBuilder.isNotLowercaseLetterOrDigit(key.charAt(0))) {
            return false;
        }
        boolean isMultiTenantVendorKey = false;
        for (int i = 1; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (ArrayBasedTraceStateBuilder.isNotLegalKeyCharacter(c)) {
                return false;
            }
            if (c != '@') continue;
            if (isMultiTenantVendorKey) {
                return false;
            }
            isMultiTenantVendorKey = true;
            if (i > 240) {
                return false;
            }
            if (key.length() - i <= 13) continue;
            return false;
        }
        if (!isMultiTenantVendorKey) {
            return ArrayBasedTraceStateBuilder.isNotDigit(key.charAt(0));
        }
        return true;
    }

    private static boolean isNotLegalKeyCharacter(char c) {
        return ArrayBasedTraceStateBuilder.isNotLowercaseLetterOrDigit(c) && c != '_' && c != '-' && c != '@' && c != '*' && c != '/';
    }

    private static boolean isNotLowercaseLetterOrDigit(char ch) {
        return (ch < 'a' || ch > 'z') && ArrayBasedTraceStateBuilder.isNotDigit(ch);
    }

    private static boolean isNotDigit(char ch) {
        return ch < '0' || ch > '9';
    }

    private static boolean isValueValid(@Nullable String value) {
        if (value == null) {
            return false;
        }
        if (value.length() > 256 || value.charAt(value.length() - 1) == ' ') {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != ',' && c != '=' && c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }
}

