/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.javaagent.shaded.instrumentation.api.context.ContextPropagationDebug;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.HttpServerTracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class BaseTracer {
    private static final Logger log = LoggerFactory.getLogger(HttpServerTracer.class);
    private static final ContextKey<Span> CONTEXT_SERVER_SPAN_KEY = ContextKey.named("opentelemetry-trace-server-span-key");
    private static final ContextKey<Span> CONTEXT_CLIENT_SPAN_KEY = ContextKey.named("opentelemetry-trace-auto-client-span-key");
    protected final Tracer tracer;
    protected final ContextPropagators propagators;

    public BaseTracer() {
        this.tracer = GlobalOpenTelemetry.getTracer(this.getInstrumentationName(), this.getVersion());
        this.propagators = GlobalOpenTelemetry.getPropagators();
    }

    @Deprecated
    public BaseTracer(Tracer tracer) {
        this.tracer = tracer;
        this.propagators = GlobalOpenTelemetry.getPropagators();
    }

    public BaseTracer(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer(this.getInstrumentationName(), this.getVersion());
        this.propagators = openTelemetry.getPropagators();
    }

    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public Span startSpan(Class<?> clazz) {
        String spanName = this.spanNameForClass(clazz);
        return this.startSpan(spanName, SpanKind.INTERNAL);
    }

    public Span startSpan(Method method) {
        String spanName = this.spanNameForMethod(method);
        return this.startSpan(spanName, SpanKind.INTERNAL);
    }

    public Span startSpan(String spanName, SpanKind kind) {
        return this.tracer.spanBuilder(spanName).setSpanKind(kind).startSpan();
    }

    protected final Context withClientSpan(Context parentContext, Span span) {
        return parentContext.with(span).with(CONTEXT_CLIENT_SPAN_KEY, span);
    }

    protected final Context withServerSpan(Context parentContext, Span span) {
        return parentContext.with(span).with(CONTEXT_SERVER_SPAN_KEY, span);
    }

    public Scope startScope(Span span) {
        return Context.current().with(span).makeCurrent();
    }

    protected final boolean shouldStartSpan(SpanKind proposedKind, Context context) {
        switch (proposedKind) {
            case CLIENT: {
                return !this.inClientSpan(context);
            }
            case SERVER: {
                return !this.inServerSpan(context);
            }
        }
        return true;
    }

    private boolean inClientSpan(Context parentContext) {
        return parentContext.get(CONTEXT_CLIENT_SPAN_KEY) != null;
    }

    private boolean inServerSpan(Context context) {
        return BaseTracer.getCurrentServerSpan(context) != null;
    }

    protected abstract String getInstrumentationName();

    protected String getVersion() {
        return InstrumentationVersion.VERSION;
    }

    public String spanNameForMethod(Method method) {
        return this.spanNameForClass(method.getDeclaringClass()) + "." + method.getName();
    }

    protected String spanNameForMethod(Class<?> clazz, Method method) {
        return this.spanNameForMethod(clazz, null == method ? null : method.getName());
    }

    protected String spanNameForMethod(Class<?> cl, String methodName) {
        return this.spanNameForClass(cl) + "." + methodName;
    }

    public String spanNameForClass(Class<?> clazz) {
        String pkgName;
        if (!clazz.isAnonymousClass()) {
            return clazz.getSimpleName();
        }
        String className = clazz.getName();
        if (clazz.getPackage() != null && !(pkgName = clazz.getPackage().getName()).isEmpty()) {
            className = clazz.getName().replace(pkgName, "").substring(1);
        }
        return className;
    }

    public void end(Context context) {
        this.end(context, -1L);
    }

    public void end(Context context, long endTimeNanos) {
        this.end(Span.fromContext(context), endTimeNanos);
    }

    public void end(Span span) {
        this.end(span, -1L);
    }

    public void end(Span span, long endTimeNanos) {
        if (endTimeNanos > 0L) {
            span.end(endTimeNanos, TimeUnit.NANOSECONDS);
        } else {
            span.end();
        }
    }

    public void endExceptionally(Context context, Throwable throwable) {
        this.endExceptionally(context, throwable, -1L);
    }

    public void endExceptionally(Context context, Throwable throwable, long endTimeNanos) {
        this.endExceptionally(Span.fromContext(context), throwable, endTimeNanos);
    }

    public void endExceptionally(Span span, Throwable throwable) {
        this.endExceptionally(span, throwable, -1L);
    }

    public void endExceptionally(Span span, Throwable throwable, long endTimeNanos) {
        span.setStatus(StatusCode.ERROR);
        this.onError(span, this.unwrapThrowable(throwable));
        this.end(span, endTimeNanos);
    }

    protected void onError(Span span, Throwable throwable) {
        this.addThrowable(span, throwable);
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        return throwable instanceof ExecutionException ? throwable.getCause() : throwable;
    }

    public void addThrowable(Span span, Throwable throwable) {
        span.recordException(throwable);
    }

    @Deprecated
    public static <C> Context extractWithGlobalPropagators(C carrier, TextMapPropagator.Getter<C> getter) {
        return BaseTracer.extract(GlobalOpenTelemetry.getPropagators(), carrier, getter);
    }

    public <C> Context extract(C carrier, TextMapPropagator.Getter<C> getter) {
        return BaseTracer.extract(this.propagators, carrier, getter);
    }

    private static <C> Context extract(ContextPropagators propagators, C carrier, TextMapPropagator.Getter<C> getter) {
        ContextPropagationDebug.debugContextLeakIfEnabled();
        return propagators.getTextMapPropagator().extract(Context.root(), carrier, getter);
    }

    public static Span getCurrentServerSpan() {
        return BaseTracer.getCurrentServerSpan(Context.current());
    }

    public static Span getCurrentServerSpan(Context context) {
        return context.get(CONTEXT_SERVER_SPAN_KEY);
    }
}

