/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.concurrent;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.concurrent.Callable;

public final class CallableWrapper
implements Callable {
    private static final Logger log = LoggerFactory.getLogger(CallableWrapper.class);
    private final Callable callable;

    public CallableWrapper(Callable callable) {
        this.callable = callable;
    }

    public Object call() throws Exception {
        return this.callable.call();
    }

    public static Callable<?> wrapIfNeeded(Callable<?> task) {
        if (task.getClass().getName().contains("/") && !(task instanceof CallableWrapper)) {
            log.debug("Wrapping callable task {}", (Object)task);
            return new CallableWrapper(task);
        }
        return task;
    }
}

