/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.servlet;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.atomic.AtomicBoolean;

public class AppServerBridge {
    private static final ContextKey<AppServerBridge> CONTEXT_KEY = ContextKey.named("opentelemetry-servlet-app-server-bridge");
    private final AtomicBoolean servletUpdatedServerSpanName = new AtomicBoolean(false);

    public static Context init(Context ctx) {
        return ctx.with(CONTEXT_KEY, new AppServerBridge());
    }

    public static boolean isPresent(Context ctx) {
        return ctx.get(CONTEXT_KEY) != null;
    }

    public static boolean isServerSpanNameUpdatedFromServlet(Context ctx) {
        AppServerBridge appServerBridge = ctx.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            return appServerBridge.servletUpdatedServerSpanName.get();
        }
        return false;
    }

    public static void setServletUpdatedServerSpanName(Context ctx, boolean value) {
        AppServerBridge appServerBridge = ctx.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            appServerBridge.servletUpdatedServerSpanName.set(value);
        }
    }
}

