/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

class AdviceTransformer {
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type OBJECT_ARRAY_TYPE = Type.getType(Object[].class);
    private static final Type ADVICE_ARGUMENT = Type.getType(Advice.Argument.class);
    private static final Type ADVICE_RETURN = Type.getType(Advice.Return.class);
    private static final Type ADVICE_ENTER = Type.getType(Advice.Enter.class);
    private static final Type ADVICE_LOCAL = Type.getType(Advice.Local.class);
    static final Type ADVICE_ON_METHOD_ENTER = Type.getType(Advice.OnMethodEnter.class);
    private static final Type ADVICE_ASSIGN_RETURNED_TO_RETURNED = Type.getType(Advice.AssignReturned.ToReturned.class);
    private static final Type ADVICE_ASSIGN_RETURNED_TO_ARGUMENTS = Type.getType(Advice.AssignReturned.ToArguments.class);
    private static final Type ADVICE_ASSIGN_RETURNED_TO_FIELDS = Type.getType(Advice.AssignReturned.ToFields.class);
    private static final Type ADVICE_ASSIGN_RETURNED_TO_ALL_ARGUMENTS = Type.getType(Advice.AssignReturned.ToAllArguments.class);
    static final Type ADVICE_ON_METHOD_EXIT = Type.getType(Advice.OnMethodExit.class);

    static byte[] transform(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(cr, 1);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 8);
        if (!AdviceTransformer.hasInlineAdvice(classNode)) {
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        final boolean justDelegateAdvice = AdviceTransformer.usesAssignReturned(classNode);
        classNode.methods.sort(Comparator.comparingInt(methodNode -> {
            if (AdviceTransformer.isEnterAdvice(methodNode)) {
                return 1;
            }
            if (AdviceTransformer.isExitAdvice(methodNode)) {
                return 2;
            }
            return 0;
        }));
        final TransformationContext context = new TransformationContext();
        ClassVisitor cv = new ClassVisitor(589824, (ClassVisitor)cw){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                final ClassVisitor classVisitor = this.cv;
                return new MethodNode(this.api, access, name, descriptor, signature, exceptions){

                    public void visitEnd() {
                        super.visitEnd();
                        if (justDelegateAdvice) {
                            AdviceTransformer.applyAdviceDelegation(context, this, classVisitor, this.exceptions.toArray(new String[0]));
                        } else {
                            AdviceTransformer.instrument(context, this, classVisitor);
                        }
                    }
                };
            }
        };
        classNode.accept(cv);
        return cw.toByteArray();
    }

    private static boolean hasInlineAdvice(ClassNode classNode) {
        for (MethodNode mn : classNode.methods) {
            if (!AdviceTransformer.hasInlineAdvice(mn)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInlineAdvice(MethodNode methodNode) {
        return AdviceTransformer.hasInlineAdvice(methodNode, ADVICE_ON_METHOD_ENTER) || AdviceTransformer.hasInlineAdvice(methodNode, ADVICE_ON_METHOD_EXIT);
    }

    private static boolean hasInlineAdvice(MethodNode methodNode, Type type) {
        AnnotationNode annotationNode = AdviceTransformer.getAnnotationNode(methodNode, type);
        if (annotationNode != null) {
            return !Boolean.FALSE.equals(AdviceTransformer.getAttributeValue(annotationNode, "inline"));
        }
        return false;
    }

    private static List<OutputArgument> getWritableArguments(MethodNode source) {
        ArrayList<OutputArgument> result = new ArrayList<OutputArgument>();
        if (source.visibleParameterAnnotations != null) {
            int i = 0;
            for (List list : source.visibleParameterAnnotations) {
                for (AnnotationNode annotationNode : list) {
                    Object value;
                    Type annotationType = Type.getType((String)annotationNode.desc);
                    if (!ADVICE_ARGUMENT.equals((Object)annotationType) || !AdviceTransformer.isWriteable(annotationNode) || !((value = AdviceTransformer.getAnnotationValue(annotationNode)) instanceof Integer)) continue;
                    result.add(new OutputArgument(i, (Integer)value));
                }
                ++i;
            }
        }
        return result;
    }

    private static OutputArgument getWritableReturnValue(MethodNode source) {
        if (source.visibleParameterAnnotations != null) {
            int i = 0;
            for (List list : source.visibleParameterAnnotations) {
                for (AnnotationNode annotationNode : list) {
                    Type annotationType = Type.getType((String)annotationNode.desc);
                    if (!ADVICE_RETURN.equals((Object)annotationType) || !AdviceTransformer.isWriteable(annotationNode)) continue;
                    return new OutputArgument(i, -1);
                }
                ++i;
            }
        }
        return null;
    }

    private static OutputArgument getEnterArgument(MethodNode source) {
        Type[] argumentTypes = Type.getArgumentTypes((String)source.desc);
        if (source.visibleParameterAnnotations != null) {
            int i = 0;
            for (List list : source.visibleParameterAnnotations) {
                for (AnnotationNode annotationNode : list) {
                    Type annotationType = Type.getType((String)annotationNode.desc);
                    if (!ADVICE_ENTER.equals((Object)annotationType) || argumentTypes[i].getDescriptor().length() <= 1) continue;
                    return new OutputArgument(i, -1);
                }
                ++i;
            }
        }
        return null;
    }

    private static List<AdviceLocal> getLocals(MethodNode source) {
        ArrayList<AdviceLocal> result = new ArrayList<AdviceLocal>();
        if (source.visibleParameterAnnotations != null) {
            int i = 0;
            for (List list : source.visibleParameterAnnotations) {
                for (AnnotationNode annotationNode : list) {
                    Object value;
                    Type annotationType = Type.getType((String)annotationNode.desc);
                    if (!ADVICE_LOCAL.equals((Object)annotationType) || !((value = AdviceTransformer.getAnnotationValue(annotationNode)) instanceof String)) continue;
                    result.add(new AdviceLocal(i, (String)value));
                }
                ++i;
            }
        }
        return result;
    }

    private static boolean usesAssignReturned(MethodNode source) {
        return AdviceTransformer.hasAnnotation(source, ADVICE_ASSIGN_RETURNED_TO_RETURNED) || AdviceTransformer.hasAnnotation(source, ADVICE_ASSIGN_RETURNED_TO_ARGUMENTS) || AdviceTransformer.hasAnnotation(source, ADVICE_ASSIGN_RETURNED_TO_FIELDS) || AdviceTransformer.hasAnnotation(source, ADVICE_ASSIGN_RETURNED_TO_ALL_ARGUMENTS);
    }

    private static boolean usesAssignReturned(ClassNode classNode) {
        for (MethodNode mn : classNode.methods) {
            if (!AdviceTransformer.usesAssignReturned(mn)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEnterAdvice(MethodNode source) {
        return AdviceTransformer.hasAnnotation(source, ADVICE_ON_METHOD_ENTER);
    }

    private static boolean isExitAdvice(MethodNode source) {
        return AdviceTransformer.hasAnnotation(source, ADVICE_ON_METHOD_EXIT);
    }

    private static AnnotationNode getAnnotationNode(MethodNode source, Type type) {
        if (source.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : source.visibleAnnotations) {
                Type annotationType = Type.getType((String)annotationNode.desc);
                if (!type.equals((Object)annotationType)) continue;
                return annotationNode;
            }
        }
        return null;
    }

    static boolean hasAnnotation(MethodNode source, Type type) {
        return AdviceTransformer.getAnnotationNode(source, type) != null;
    }

    private static MethodVisitor instrumentWritableArguments(MethodVisitor target, final MethodNode source, final List<OutputArgument> writableArguments, final int returnIndex) {
        MethodVisitor result = new MethodVisitor(589824, target){

            public void visitCode() {
                AnnotationVisitor av = this.visitAnnotation(Type.getDescriptor(Advice.AssignReturned.ToArguments.class), true);
                AnnotationVisitor valueArrayVisitor = av.visitArray("value");
                for (int i = 0; i < writableArguments.size(); ++i) {
                    OutputArgument argument = (OutputArgument)writableArguments.get(i);
                    AnnotationVisitor valueVisitor = valueArrayVisitor.visitAnnotation(null, Type.getDescriptor(Advice.AssignReturned.ToArguments.ToArgument.class));
                    valueVisitor.visit("value", (Object)argument.methodIndex);
                    valueVisitor.visit("index", (Object)(returnIndex + i));
                    valueVisitor.visitEnum("typing", Type.getDescriptor(Assigner.Typing.class), "DYNAMIC");
                    valueVisitor.visitEnd();
                }
                valueArrayVisitor.visitEnd();
                av.visitEnd();
                super.visitCode();
            }

            public void visitInsn(int opcode) {
                if (176 == opcode) {
                    GeneratorAdapter ga = new GeneratorAdapter(this.mv, source.access, source.name, source.desc);
                    Type[] argumentTypes = ga.getArgumentTypes();
                    for (int i = 0; i < writableArguments.size(); ++i) {
                        OutputArgument argument = (OutputArgument)writableArguments.get(i);
                        ga.dup();
                        ga.push(returnIndex + i);
                        ga.loadArg(argument.adviceIndex);
                        ga.box(argumentTypes[argument.adviceIndex]);
                        ga.arrayStore(OBJECT_TYPE);
                    }
                }
                super.visitInsn(opcode);
            }
        };
        result = AdviceTransformer.makeReadOnly(Advice.Argument.class, result);
        return result;
    }

    private static MethodVisitor instrumentWritableReturn(MethodVisitor target, final MethodNode source, final OutputArgument writableReturn, final int returnIndex) {
        MethodVisitor result = new MethodVisitor(589824, target){

            public void visitCode() {
                AnnotationVisitor av = this.visitAnnotation(Type.getDescriptor(Advice.AssignReturned.ToReturned.class), true);
                av.visit("index", (Object)returnIndex);
                av.visitEnum("typing", Type.getDescriptor(Assigner.Typing.class), "DYNAMIC");
                av.visitEnd();
                super.visitCode();
            }

            public void visitInsn(int opcode) {
                if (176 == opcode) {
                    GeneratorAdapter ga = new GeneratorAdapter(this.mv, source.access, source.name, source.desc);
                    Type[] argumentTypes = ga.getArgumentTypes();
                    ga.dup();
                    ga.push(returnIndex);
                    ga.loadArg(writableReturn.adviceIndex);
                    ga.box(argumentTypes[writableReturn.adviceIndex]);
                    ga.arrayStore(OBJECT_TYPE);
                }
                super.visitInsn(opcode);
            }
        };
        result = AdviceTransformer.makeReadOnly(Advice.Return.class, result);
        return result;
    }

    private static MethodVisitor instrumentAdviceLocals(final boolean isEnterAdvice, MethodVisitor target, MethodNode source, String originalDesc, final List<AdviceLocal> adviceLocals, final OutputArgument enterArgument, final int returnIndex) {
        final AtomicReference<GeneratorAdapter> generatorRef = new AtomicReference<GeneratorAdapter>();
        final AtomicInteger dataIndex = new AtomicInteger();
        target = new MethodVisitor(589824, target){

            public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
                if (Type.getDescriptor(Advice.Local.class).equals(descriptor)) {
                    descriptor = Type.getDescriptor(Advice.Unused.class);
                }
                if (enterArgument != null && enterArgument.adviceIndex == parameter && Type.getDescriptor(Advice.Enter.class).equals(descriptor)) {
                    descriptor = Type.getDescriptor(Advice.Unused.class);
                }
                return super.visitParameterAnnotation(parameter, descriptor, visible);
            }

            public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
                if (!isEnterAdvice) {
                    ++parameterCount;
                }
                super.visitAnnotableParameterCount(parameterCount, visible);
            }

            public void visitInsn(int opcode) {
                if (isEnterAdvice && 176 == opcode) {
                    GeneratorAdapter ga = (GeneratorAdapter)generatorRef.get();
                    ga.dup();
                    ga.push(returnIndex);
                    Type hashMapType = Type.getType(HashMap.class);
                    Type[] argumentTypes = ga.getArgumentTypes();
                    ga.newInstance(hashMapType);
                    ga.dup();
                    ga.invokeConstructor(hashMapType, Method.getMethod((String)"void <init>()"));
                    for (AdviceLocal adviceLocal : adviceLocals) {
                        ga.dup();
                        ga.push(adviceLocal.name);
                        ga.loadArg(adviceLocal.adviceIndex);
                        ga.box(argumentTypes[adviceLocal.adviceIndex]);
                        ga.invokeVirtual(hashMapType, Method.getMethod((String)"java.lang.Object put(java.lang.Object, java.lang.Object)"));
                        ga.pop();
                    }
                    ga.arrayStore(OBJECT_TYPE);
                }
                super.visitInsn(opcode);
            }

            public void visitCode() {
                super.visitCode();
                GeneratorAdapter ga = (GeneratorAdapter)generatorRef.get();
                Type[] argumentTypes = ga.getArgumentTypes();
                if (isEnterAdvice) {
                    for (AdviceLocal adviceLocal : adviceLocals) {
                        ga.loadArg(adviceLocal.adviceIndex);
                        ga.checkCast(argumentTypes[adviceLocal.adviceIndex]);
                        ga.storeArg(adviceLocal.adviceIndex);
                    }
                    return;
                }
                int lastArgumentIndex = argumentTypes.length;
                AnnotationVisitor av = this.mv.visitParameterAnnotation(lastArgumentIndex, Type.getDescriptor(Advice.Enter.class), true);
                av.visitEnd();
                ga.loadLocal(dataIndex.get(), OBJECT_ARRAY_TYPE);
                if (enterArgument != null) {
                    ga.dup();
                    ga.push(0);
                    Type type = argumentTypes[enterArgument.adviceIndex];
                    ga.arrayLoad(type);
                    ga.checkCast(type);
                    ga.storeArg(enterArgument.adviceIndex);
                }
                ga.dup();
                Type mapType = Type.getType(Map.class);
                ga.arrayLength();
                ga.visitInsn(4);
                ga.visitInsn(100);
                ga.arrayLoad(mapType);
                for (AdviceLocal adviceLocal : adviceLocals) {
                    ga.dup();
                    ga.push(adviceLocal.name);
                    ga.invokeInterface(mapType, Method.getMethod((String)"java.lang.Object get(java.lang.Object)"));
                    ga.unbox(argumentTypes[adviceLocal.adviceIndex]);
                    ga.storeArg(adviceLocal.adviceIndex);
                }
                ga.pop();
            }
        };
        GeneratorAdapter ga = new GeneratorAdapter(target, 8, source.name, originalDesc);
        generatorRef.set(ga);
        if (!isEnterAdvice) {
            dataIndex.set(ga.newLocal(OBJECT_ARRAY_TYPE));
        }
        return ga;
    }

    private static void instrument(TransformationContext context, MethodNode methodNode, ClassVisitor classVisitor) {
        String originalDescriptor = methodNode.desc;
        String[] exceptionsArray = methodNode.exceptions.toArray(new String[0]);
        List<OutputArgument> writableArguments = AdviceTransformer.getWritableArguments(methodNode);
        OutputArgument writableReturn = AdviceTransformer.getWritableReturnValue(methodNode);
        OutputArgument enterArgument = AdviceTransformer.getEnterArgument(methodNode);
        List<AdviceLocal> adviceLocals = AdviceTransformer.getLocals(methodNode);
        boolean isEnterAdvice = AdviceTransformer.isEnterAdvice(methodNode);
        boolean isExitAdvice = AdviceTransformer.isExitAdvice(methodNode);
        Type returnType = Type.getReturnType((String)methodNode.desc);
        if (isEnterAdvice && returnType.getSort() != 0 && returnType.getSort() != 10 && returnType.getSort() != 9) {
            context.disableReturnTypeChange();
        }
        if (!context.canChangeReturnType()) {
            enterArgument = null;
        }
        if (context.canChangeReturnType() || isExitAdvice && Type.VOID_TYPE.equals((Object)returnType)) {
            if (!writableArguments.isEmpty() || writableReturn != null || !Type.VOID_TYPE.equals((Object)returnType) || !adviceLocals.isEmpty() && isEnterAdvice) {
                Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
                if (!adviceLocals.isEmpty() && isEnterAdvice) {
                    for (AdviceLocal adviceLocal : adviceLocals) {
                        argumentTypes[adviceLocal.adviceIndex] = OBJECT_TYPE;
                    }
                }
                methodNode.desc = Type.getMethodDescriptor((Type)OBJECT_ARRAY_TYPE, (Type[])argumentTypes);
                MethodNode tmp = new MethodNode(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, exceptionsArray);
                MethodVisitor mv = AdviceTransformer.instrumentOurParameters(context, (MethodVisitor)tmp, methodNode, originalDescriptor, writableArguments, writableReturn, adviceLocals);
                methodNode.accept(mv);
                methodNode = tmp;
                adviceLocals = AdviceTransformer.getLocals(methodNode);
            }
            if ((!adviceLocals.isEmpty() || enterArgument != null) && isExitAdvice) {
                Type[] newArgumentTypes = Type.getArgumentTypes((String)methodNode.desc);
                for (AdviceLocal adviceLocal : adviceLocals) {
                    newArgumentTypes[adviceLocal.adviceIndex] = OBJECT_TYPE;
                }
                if (enterArgument != null) {
                    newArgumentTypes[enterArgument.adviceIndex] = OBJECT_TYPE;
                }
                ArrayList<Type> typeList = new ArrayList<Type>(Arrays.asList(newArgumentTypes));
                typeList.add(OBJECT_ARRAY_TYPE);
                methodNode.desc = Type.getMethodDescriptor((Type)Type.getReturnType((String)methodNode.desc), (Type[])typeList.toArray(new Type[0]));
                MethodNode tmp = new MethodNode(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, exceptionsArray);
                MethodVisitor mv = AdviceTransformer.instrumentAdviceLocals(false, (MethodVisitor)tmp, methodNode, originalDescriptor, adviceLocals, enterArgument, -1);
                methodNode.accept(mv);
                methodNode = tmp;
            }
        }
        AdviceTransformer.applyAdviceDelegation(context, methodNode, classVisitor, exceptionsArray);
    }

    private static void applyAdviceDelegation(TransformationContext context, MethodNode methodNode, ClassVisitor classVisitor, String[] exceptionsArray) {
        MethodVisitor mv = classVisitor.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, exceptionsArray);
        mv = AdviceTransformer.delegateAdvice(context, mv);
        methodNode.accept(mv);
    }

    private static MethodVisitor instrumentOurParameters(TransformationContext context, MethodVisitor target, MethodNode source, String originalDesc, List<OutputArgument> writableArguments, OutputArgument writableReturn, List<AdviceLocal> adviceLocals) {
        int returnArraySize;
        int n = returnArraySize = AdviceTransformer.isEnterAdvice(source) ? 1 : 0;
        if (writableReturn != null) {
            target = AdviceTransformer.instrumentWritableReturn(target, source, writableReturn, returnArraySize);
            ++returnArraySize;
        }
        if (!writableArguments.isEmpty()) {
            target = AdviceTransformer.instrumentWritableArguments(target, source, writableArguments, returnArraySize);
            returnArraySize += writableArguments.size();
        }
        if (!adviceLocals.isEmpty() && AdviceTransformer.isEnterAdvice(source)) {
            target = AdviceTransformer.instrumentAdviceLocals(true, target, source, originalDesc, adviceLocals, null, returnArraySize);
            ++returnArraySize;
        }
        target = AdviceTransformer.addReturnArray(context, target, returnArraySize);
        return target;
    }

    private static boolean isWriteable(AnnotationNode annotationNode) {
        Object value = AdviceTransformer.getAttributeValue(annotationNode, "readOnly");
        return Boolean.FALSE.equals(value);
    }

    private static Object getAttributeValue(AnnotationNode annotationNode, String attributeName) {
        if (annotationNode.values != null && !annotationNode.values.isEmpty()) {
            List values = annotationNode.values;
            for (int i = 0; i < values.size(); i += 2) {
                String name = (String)values.get(i);
                Object value = values.get(i + 1);
                if (!attributeName.equals(name)) continue;
                return value;
            }
        }
        return null;
    }

    private static Object getAnnotationValue(AnnotationNode annotationNode) {
        if (annotationNode.values != null && !annotationNode.values.isEmpty()) {
            List values = annotationNode.values;
            for (int i = 0; i < values.size(); i += 2) {
                String attributeName = (String)values.get(i);
                Object attributeValue = values.get(i + 1);
                if (!"value".equals(attributeName)) continue;
                return attributeValue;
            }
        }
        return null;
    }

    private static MethodVisitor addReturnArray(final TransformationContext context, MethodVisitor target, final int returnArraySize) {
        return new MethodVisitor(589824, target){

            public void visitInsn(int opcode) {
                if (177 == opcode) {
                    GeneratorAdapter ga = new GeneratorAdapter(this.mv, 0, null, "()V");
                    ga.push(returnArraySize);
                    ga.newArray(OBJECT_TYPE);
                    opcode = 176;
                } else if (context.canChangeReturnType() && 176 == opcode) {
                    GeneratorAdapter ga = new GeneratorAdapter(this.mv, 0, null, "()V");
                    ga.push(returnArraySize);
                    ga.newArray(OBJECT_TYPE);
                    ga.dupX1();
                    ga.swap();
                    ga.push(0);
                    ga.swap();
                    ga.arrayStore(OBJECT_TYPE);
                }
                super.visitInsn(opcode);
            }
        };
    }

    private static MethodVisitor delegateAdvice(final TransformationContext context, MethodVisitor target) {
        return new MethodVisitor(589824, target){

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
                Type type = Type.getType((String)descriptor);
                if (!Type.getType(Advice.OnMethodEnter.class).equals((Object)type) && !Type.getType(Advice.OnMethodExit.class).equals((Object)type)) {
                    return av;
                }
                return new AnnotationVisitor(this.api, av){
                    boolean hasInline;
                    boolean hasSkipOn;
                    {
                        super(api, annotationVisitor);
                        this.hasInline = false;
                        this.hasSkipOn = false;
                    }

                    public void visit(String name, Object value) {
                        if ("inline".equals(name)) {
                            value = Boolean.FALSE;
                            this.hasInline = true;
                        } else if ("skipOn".equals(name) && value != Void.TYPE) {
                            this.hasSkipOn = true;
                        }
                        super.visit(name, value);
                    }

                    public void visitEnd() {
                        if (!this.hasInline) {
                            this.visit("inline", Boolean.FALSE);
                        }
                        if (context.canChangeReturnType() && this.hasSkipOn) {
                            this.visit("skipOnIndex", 0);
                        }
                        super.visitEnd();
                    }
                };
            }
        };
    }

    private static MethodVisitor makeReadOnly(final Class<?> annotationType, MethodVisitor target) {
        return new MethodVisitor(589824, target){

            public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
                AnnotationVisitor av = super.visitParameterAnnotation(parameter, descriptor, visible);
                Type type = Type.getType((String)descriptor);
                if (!Type.getType((Class)annotationType).equals((Object)type)) {
                    return av;
                }
                return new AnnotationVisitor(this.api, av){

                    public void visit(String name, Object value) {
                        if ("readOnly".equals(name)) {
                            value = Boolean.TRUE;
                        }
                        super.visit(name, value);
                    }
                };
            }
        };
    }

    private AdviceTransformer() {
    }

    private static class TransformationContext {
        private boolean canChangeReturnType = true;

        private TransformationContext() {
        }

        void disableReturnTypeChange() {
            this.canChangeReturnType = false;
        }

        boolean canChangeReturnType() {
            return this.canChangeReturnType;
        }
    }

    private static class OutputArgument {
        final int adviceIndex;
        final int methodIndex;

        OutputArgument(int adviceIndex, int methodIndex) {
            this.adviceIndex = adviceIndex;
            this.methodIndex = methodIndex;
        }
    }

    private static class AdviceLocal {
        final int adviceIndex;
        final String name;

        AdviceLocal(int adviceIndex, String name) {
            this.adviceIndex = adviceIndex;
            this.name = name;
        }
    }
}

