/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.internal.ExperimentalInstrumentationModule;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.InstrumentationModuleClassLoader;
import io.opentelemetry.javaagent.tooling.util.ClassLoaderValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.agent.builder.AgentBuilder;

public class IndyModuleRegistry {
    private static final ConcurrentHashMap<String, InstrumentationModule> modulesByClassName = new ConcurrentHashMap();
    private static final ClassLoaderValue<Map<String, InstrumentationModuleClassLoader>> instrumentationClassLoaders = new ClassLoaderValue();

    private IndyModuleRegistry() {
    }

    public static InstrumentationModuleClassLoader getInstrumentationClassLoader(String moduleClassName, ClassLoader instrumentedClassLoader) {
        InstrumentationModule instrumentationModule = modulesByClassName.get(moduleClassName);
        if (instrumentationModule == null) {
            throw new IllegalArgumentException("No module with the class name " + modulesByClassName + " has been registered!");
        }
        return IndyModuleRegistry.getInstrumentationClassLoader(instrumentationModule, instrumentedClassLoader);
    }

    public static InstrumentationModuleClassLoader getInstrumentationClassLoader(InstrumentationModule module, ClassLoader instrumentedClassLoader) {
        String groupName = IndyModuleRegistry.getModuleGroup(module);
        Map<String, InstrumentationModuleClassLoader> loadersByGroupName = instrumentationClassLoaders.get(instrumentedClassLoader);
        if (loadersByGroupName == null) {
            throw new IllegalArgumentException(module + " has not been initialized for class loader " + instrumentedClassLoader + " yet");
        }
        InstrumentationModuleClassLoader loader = loadersByGroupName.get(groupName);
        if (loader == null || !loader.hasModuleInstalled(module)) {
            throw new IllegalArgumentException(module + " has not been initialized for class loader " + instrumentedClassLoader + " yet");
        }
        return loader;
    }

    public static InstrumentationModuleClassLoader createInstrumentationClassLoaderWithoutRegistration(InstrumentationModule module, ClassLoader instrumentedClassLoader) {
        ClassLoader agentOrExtensionCl = module.getClass().getClassLoader();
        InstrumentationModuleClassLoader cl = new InstrumentationModuleClassLoader(instrumentedClassLoader, agentOrExtensionCl);
        cl.installModule(module);
        return cl;
    }

    public static AgentBuilder.Identified.Extendable initializeModuleLoaderOnMatch(InstrumentationModule module, AgentBuilder.Identified.Extendable agentBuilder) {
        if (!module.isIndyModule()) {
            throw new IllegalArgumentException("Provided module is not an indy module!");
        }
        String moduleName = module.getClass().getName();
        InstrumentationModule existingRegistration = modulesByClassName.putIfAbsent(moduleName, module);
        if (existingRegistration != null && existingRegistration != module) {
            throw new IllegalArgumentException("A different module with the class name " + moduleName + " has already been registered!");
        }
        return agentBuilder.transform((builder, typeDescription, classLoader, javaModule, protectionDomain) -> {
            IndyModuleRegistry.initializeModuleLoaderForClassLoader(module, classLoader);
            return builder;
        });
    }

    private static void initializeModuleLoaderForClassLoader(InstrumentationModule module, ClassLoader classLoader) {
        ClassLoader agentOrExtensionCl = module.getClass().getClassLoader();
        String groupName = IndyModuleRegistry.getModuleGroup(module);
        InstrumentationModuleClassLoader moduleCl = instrumentationClassLoaders.computeIfAbsent(classLoader, ConcurrentHashMap::new).computeIfAbsent(groupName, unused -> new InstrumentationModuleClassLoader(classLoader, agentOrExtensionCl));
        moduleCl.installModule(module);
    }

    private static String getModuleGroup(InstrumentationModule module) {
        if (module instanceof ExperimentalInstrumentationModule) {
            return ((ExperimentalInstrumentationModule)module).getModuleGroup();
        }
        return module.getClass().getName();
    }
}

