/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.bootstrap.IndyBootstrapDispatcher;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyModuleRegistry;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyProxyFactory;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.InstrumentationModuleClassLoader;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.utility.JavaConstant;

public class IndyBootstrap {
    private static final Logger logger = Logger.getLogger(IndyBootstrap.class.getName());
    private static final Method indyBootstrapMethod;
    private static final String BOOTSTRAP_KIND_ADVICE = "advice";
    private static final String BOOTSTRAP_KIND_PROXY = "proxy";
    private static final String PROXY_KIND_STATIC = "static";
    private static final String PROXY_KIND_CONSTRUCTOR = "constructor";
    private static final String PROXY_KIND_VIRTUAL = "virtual";

    private IndyBootstrap() {
    }

    public static Method getIndyBootstrapMethod() {
        return indyBootstrapMethod;
    }

    @Nullable
    private static ConstantCallSite bootstrap(MethodHandles.Lookup lookup, String adviceMethodName, MethodType adviceMethodType, Object[] args) {
        if (System.getSecurityManager() == null) {
            return IndyBootstrap.internalBootstrap(lookup, adviceMethodName, adviceMethodType, args);
        }
        return AccessController.doPrivileged(() -> IndyBootstrap.internalBootstrap(lookup, adviceMethodName, adviceMethodType, args));
    }

    private static ConstantCallSite internalBootstrap(MethodHandles.Lookup lookup, String adviceMethodName, MethodType adviceMethodType, Object[] args) {
        try {
            String kind;
            switch (kind = (String)args[0]) {
                case "advice": {
                    return IndyBootstrap.bootstrapAdvice(lookup, adviceMethodName, adviceMethodType, (String)args[1], (String)args[2]);
                }
                case "proxy": {
                    return IndyBootstrap.bootstrapProxyMethod(lookup, adviceMethodName, adviceMethodType, (String)args[1], (String)args[2], (String)args[3]);
                }
            }
            throw new IllegalArgumentException("Unknown bootstrapping kind: " + kind);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConstantCallSite bootstrapAdvice(MethodHandles.Lookup lookup, String adviceMethodName, MethodType adviceMethodType, String moduleClassName, String adviceClassName) throws NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        CallDepth callDepth = CallDepth.forClass(IndyBootstrap.class);
        try {
            if (callDepth.getAndIncrement() > 0) {
                logger.log(Level.WARNING, "Nested instrumented invokedynamic instruction linkage detected", new Throwable());
                ConstantCallSite constantCallSite = null;
                return constantCallSite;
            }
            InstrumentationModuleClassLoader instrumentationClassloader = IndyModuleRegistry.getInstrumentationClassLoader(moduleClassName, lookup.lookupClass().getClassLoader());
            Class<?> adviceClass = instrumentationClassloader.loadClass(adviceClassName);
            MethodHandle methodHandle = instrumentationClassloader.getLookup().findStatic(adviceClass, adviceMethodName, adviceMethodType);
            ConstantCallSite constantCallSite = new ConstantCallSite(methodHandle);
            return constantCallSite;
        }
        finally {
            callDepth.decrementAndGet();
        }
    }

    static Advice.BootstrapArgumentResolver.Factory getAdviceBootstrapArguments(InstrumentationModule instrumentationModule) {
        String moduleName = instrumentationModule.getClass().getName();
        return (adviceMethod, exit) -> (instrumentedType, instrumentedMethod) -> Arrays.asList(JavaConstant.Simple.ofLoaded((Object)BOOTSTRAP_KIND_ADVICE), JavaConstant.Simple.ofLoaded((Object)moduleName), JavaConstant.Simple.ofLoaded((Object)adviceMethod.getDeclaringType().getName()));
    }

    private static ConstantCallSite bootstrapProxyMethod(MethodHandles.Lookup lookup, String proxyMethodName, MethodType expectedMethodType, String moduleClassName, String proxyClassName, String methodKind) throws NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        MethodHandle target;
        InstrumentationModuleClassLoader instrumentationClassloader = IndyModuleRegistry.getInstrumentationClassLoader(moduleClassName, lookup.lookupClass().getClassLoader());
        Class<?> proxiedClass = instrumentationClassloader.loadClass(proxyClassName);
        switch (methodKind) {
            case "static": {
                target = MethodHandles.publicLookup().findStatic(proxiedClass, proxyMethodName, expectedMethodType);
                break;
            }
            case "constructor": {
                target = MethodHandles.publicLookup().findConstructor(proxiedClass, expectedMethodType.changeReturnType(Void.TYPE)).asType(expectedMethodType);
                break;
            }
            case "virtual": {
                target = MethodHandles.publicLookup().findVirtual(proxiedClass, proxyMethodName, expectedMethodType.dropParameterTypes(0, 1)).asType(expectedMethodType);
                break;
            }
            default: {
                throw new IllegalStateException("unknown proxy method kind: " + methodKind);
            }
        }
        return new ConstantCallSite(target);
    }

    public static IndyProxyFactory getProxyFactory(InstrumentationModule instrumentationModule) {
        String moduleName = instrumentationModule.getClass().getName();
        return new IndyProxyFactory(IndyBootstrap.getIndyBootstrapMethod(), (proxiedType, proxiedMethod) -> {
            String methodKind;
            if (proxiedMethod.isConstructor()) {
                methodKind = PROXY_KIND_CONSTRUCTOR;
            } else if (proxiedMethod.isMethod()) {
                methodKind = proxiedMethod.isStatic() ? PROXY_KIND_STATIC : PROXY_KIND_VIRTUAL;
            } else {
                throw new IllegalArgumentException("Unknown type of method: " + proxiedMethod.getName());
            }
            return Arrays.asList(JavaConstant.Simple.ofLoaded((Object)BOOTSTRAP_KIND_PROXY), JavaConstant.Simple.ofLoaded((Object)moduleName), JavaConstant.Simple.ofLoaded((Object)proxiedType.getName()), JavaConstant.Simple.ofLoaded((Object)methodKind));
        });
    }

    static {
        try {
            indyBootstrapMethod = IndyBootstrapDispatcher.class.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
            MethodType bootstrapMethodType = MethodType.methodType(ConstantCallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
            IndyBootstrapDispatcher.init((MethodHandle)MethodHandles.lookup().findStatic(IndyBootstrap.class, "bootstrap", bootstrapMethodType));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

