/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.tooling.config.ConfigurationFile;
import java.util.Map;
import javax.annotation.Nullable;

public final class EarlyInitAgentConfig {
    private final Map<String, String> configFileContents;

    public static EarlyInitAgentConfig create() {
        return new EarlyInitAgentConfig(ConfigurationFile.getProperties());
    }

    private EarlyInitAgentConfig(Map<String, String> configFileContents) {
        this.configFileContents = configFileContents;
    }

    @Nullable
    public String getString(String propertyName) {
        String value = ConfigPropertiesUtil.getString((String)propertyName);
        if (value != null) {
            return value;
        }
        return this.configFileContents.get(propertyName);
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        String configFileValueStr = this.configFileContents.get(propertyName);
        boolean configFileValue = configFileValueStr == null ? defaultValue : Boolean.parseBoolean(configFileValueStr);
        return ConfigPropertiesUtil.getBoolean((String)propertyName, (boolean)configFileValue);
    }

    public int getInt(String propertyName, int defaultValue) {
        try {
            String configFileValueStr = this.configFileContents.get(propertyName);
            int configFileValue = configFileValueStr == null ? defaultValue : Integer.parseInt(configFileValueStr);
            return ConfigPropertiesUtil.getInt((String)propertyName, (int)configFileValue);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    public void logEarlyConfigErrorsIfAny() {
        ConfigurationFile.logErrorIfAny();
    }
}

