/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation;

import io.opentelemetry.javaagent.extension.instrumentation.HelperResourceBuilder;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.instrumentation.internal.ExperimentalInstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.internal.injection.ClassInjector;
import io.opentelemetry.javaagent.extension.instrumentation.internal.injection.InjectionMode;
import io.opentelemetry.javaagent.tooling.HelperClassDefinition;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.ModuleOpener;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.bytebuddy.LoggingFailSafeMatcher;
import io.opentelemetry.javaagent.tooling.config.AgentConfig;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementationInstaller;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementationInstallerFactory;
import io.opentelemetry.javaagent.tooling.instrumentation.ConstantAdjuster;
import io.opentelemetry.javaagent.tooling.instrumentation.MuzzleMatcher;
import io.opentelemetry.javaagent.tooling.instrumentation.TypeTransformerImpl;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.ClassInjectorImpl;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.ForwardIndyAdviceTransformer;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyModuleRegistry;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyTypeTransformerImpl;
import io.opentelemetry.javaagent.tooling.muzzle.HelperResourceBuilderImpl;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.util.IgnoreFailedTypeMatcher;
import io.opentelemetry.javaagent.tooling.util.NamedMatcher;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public final class InstrumentationModuleInstaller {
    static final TransformSafeLogger logger = TransformSafeLogger.getLogger(InstrumentationModule.class);
    public static final ElementMatcher.Junction<AnnotationSource> NOT_DECORATOR_MATCHER = ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"javax.decorator.Decorator")));
    private final Instrumentation instrumentation;
    private final VirtualFieldImplementationInstallerFactory virtualFieldInstallerFactory = VirtualFieldImplementationInstallerFactory.getInstance();

    public InstrumentationModuleInstaller(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    AgentBuilder install(InstrumentationModule instrumentationModule, AgentBuilder parentAgentBuilder, ConfigProperties config) {
        if (!AgentConfig.isInstrumentationEnabled(config, instrumentationModule.instrumentationNames(), instrumentationModule.defaultEnabled(config))) {
            logger.log(Level.FINE, "Instrumentation {0} is disabled", (Object)instrumentationModule.instrumentationName());
            return parentAgentBuilder;
        }
        if (instrumentationModule.isIndyModule()) {
            return this.installIndyModule(instrumentationModule, parentAgentBuilder, config);
        }
        return this.installInjectingModule(instrumentationModule, parentAgentBuilder, config);
    }

    private AgentBuilder installIndyModule(InstrumentationModule instrumentationModule, AgentBuilder parentAgentBuilder, ConfigProperties config) {
        List injectedHelperClassNames;
        List helperClassNames = InstrumentationModuleMuzzle.getHelperClassNames((InstrumentationModule)instrumentationModule);
        HelperResourceBuilderImpl helperResourceBuilder = new HelperResourceBuilderImpl();
        instrumentationModule.registerHelperResources((HelperResourceBuilder)helperResourceBuilder);
        List typeInstrumentations = instrumentationModule.typeInstrumentations();
        if (typeInstrumentations.isEmpty()) {
            if (!helperClassNames.isEmpty() || !helperResourceBuilder.getResources().isEmpty()) {
                logger.log(Level.WARNING, "Helper classes and resources won't be injected if no types are instrumented: {0}", (Object)instrumentationModule.instrumentationName());
            }
            return parentAgentBuilder;
        }
        if (instrumentationModule instanceof ExperimentalInstrumentationModule) {
            ExperimentalInstrumentationModule experimentalInstrumentationModule = (ExperimentalInstrumentationModule)instrumentationModule;
            injectedHelperClassNames = experimentalInstrumentationModule.injectedClassNames();
        } else {
            injectedHelperClassNames = Collections.emptyList();
        }
        ClassInjectorImpl injectedClassesCollector = new ClassInjectorImpl(instrumentationModule);
        if (instrumentationModule instanceof ExperimentalInstrumentationModule) {
            ((ExperimentalInstrumentationModule)instrumentationModule).injectClasses((ClassInjector)injectedClassesCollector);
        }
        MuzzleMatcher muzzleMatcher = new MuzzleMatcher(logger, instrumentationModule, config);
        Function<ClassLoader, List> helperGenerator = cl -> {
            ArrayList<HelperClassDefinition> helpers = new ArrayList<HelperClassDefinition>(injectedClassesCollector.getClassesToInject((ClassLoader)cl));
            for (String helperName : injectedHelperClassNames) {
                helpers.add(HelperClassDefinition.create((String)helperName, (ClassLoader)instrumentationModule.getClass().getClassLoader(), (InjectionMode)InjectionMode.CLASS_ONLY));
            }
            return helpers;
        };
        HelperInjector helperInjector = new HelperInjector(instrumentationModule.instrumentationName(), helperGenerator, helperResourceBuilder.getResources(), instrumentationModule.getClass().getClassLoader(), this.instrumentation);
        VirtualFieldImplementationInstaller contextProvider = this.virtualFieldInstallerFactory.create(instrumentationModule);
        AgentBuilder agentBuilder = parentAgentBuilder;
        for (TypeInstrumentation typeInstrumentation : instrumentationModule.typeInstrumentations()) {
            AgentBuilder.Identified.Extendable extendableAgentBuilder = ((AgentBuilder.Identified.Narrowable)InstrumentationModuleInstaller.setTypeMatcher(agentBuilder, instrumentationModule, typeInstrumentation).and((AgentBuilder.RawMatcher)muzzleMatcher)).transform(ConstantAdjuster.instance()).transform((AgentBuilder.Transformer)new ForwardIndyAdviceTransformer(helperInjector));
            extendableAgentBuilder = IndyModuleRegistry.initializeModuleLoaderOnMatch(instrumentationModule, extendableAgentBuilder);
            extendableAgentBuilder = extendableAgentBuilder.transform((AgentBuilder.Transformer)helperInjector);
            extendableAgentBuilder = contextProvider.injectHelperClasses(extendableAgentBuilder);
            IndyTypeTransformerImpl typeTransformer = new IndyTypeTransformerImpl(extendableAgentBuilder, instrumentationModule);
            typeInstrumentation.transform((TypeTransformer)typeTransformer);
            extendableAgentBuilder = typeTransformer.getAgentBuilder();
            extendableAgentBuilder = contextProvider.injectFields(extendableAgentBuilder);
            agentBuilder = extendableAgentBuilder;
        }
        return agentBuilder;
    }

    private AgentBuilder installInjectingModule(InstrumentationModule instrumentationModule, AgentBuilder parentAgentBuilder, ConfigProperties config) {
        List helperClassNames = InstrumentationModuleMuzzle.getHelperClassNames((InstrumentationModule)instrumentationModule);
        HelperResourceBuilderImpl helperResourceBuilder = new HelperResourceBuilderImpl();
        instrumentationModule.registerHelperResources((HelperResourceBuilder)helperResourceBuilder);
        List typeInstrumentations = instrumentationModule.typeInstrumentations();
        if (typeInstrumentations.isEmpty()) {
            if (!helperClassNames.isEmpty() || !helperResourceBuilder.getResources().isEmpty()) {
                logger.log(Level.WARNING, "Helper classes and resources won't be injected if no types are instrumented: {0}", (Object)instrumentationModule.instrumentationName());
            }
            return parentAgentBuilder;
        }
        MuzzleMatcher muzzleMatcher = new MuzzleMatcher(logger, instrumentationModule, config);
        HelperInjector helperInjector = new HelperInjector(instrumentationModule.instrumentationName(), helperClassNames, helperResourceBuilder.getResources(), Utils.getExtensionsClassLoader(), this.instrumentation);
        VirtualFieldImplementationInstaller contextProvider = this.virtualFieldInstallerFactory.create(instrumentationModule);
        AtomicBoolean openerRun = new AtomicBoolean();
        AgentBuilder agentBuilder = parentAgentBuilder;
        for (TypeInstrumentation typeInstrumentation : typeInstrumentations) {
            AgentBuilder.Identified.Extendable extendableAgentBuilder = ((AgentBuilder.Identified.Narrowable)InstrumentationModuleInstaller.setTypeMatcher(agentBuilder, instrumentationModule, typeInstrumentation).and((AgentBuilder.RawMatcher)muzzleMatcher)).transform(ConstantAdjuster.instance()).transform((builder, typeDescription, classLoader, module, protectionDomain) -> {
                if (JavaModule.isSupported() && instrumentationModule instanceof ExperimentalInstrumentationModule && !openerRun.get()) {
                    ExperimentalInstrumentationModule experimentalModule = (ExperimentalInstrumentationModule)instrumentationModule;
                    experimentalModule.jpmsModulesToOpen().forEach((javaModule, packages) -> ModuleOpener.open((Instrumentation)this.instrumentation, (JavaModule)javaModule, (ClassLoader)classLoader, (Collection)packages));
                    openerRun.set(true);
                }
                return builder;
            }).transform((AgentBuilder.Transformer)helperInjector);
            extendableAgentBuilder = contextProvider.injectHelperClasses(extendableAgentBuilder);
            extendableAgentBuilder = contextProvider.rewriteVirtualFieldsCalls(extendableAgentBuilder);
            TypeTransformerImpl typeTransformer = new TypeTransformerImpl(extendableAgentBuilder);
            typeInstrumentation.transform((TypeTransformer)typeTransformer);
            extendableAgentBuilder = typeTransformer.getAgentBuilder();
            extendableAgentBuilder = contextProvider.injectFields(extendableAgentBuilder);
            agentBuilder = extendableAgentBuilder;
        }
        return agentBuilder;
    }

    private static AgentBuilder.Identified.Narrowable setTypeMatcher(AgentBuilder agentBuilder, InstrumentationModule instrumentationModule, TypeInstrumentation typeInstrumentation) {
        ElementMatcher.Junction moduleClassLoaderMatcher = instrumentationModule.classLoaderMatcher();
        NamedMatcher<TypeDescription> typeMatcher = new NamedMatcher<TypeDescription>(instrumentationModule.getClass().getSimpleName() + "#" + typeInstrumentation.getClass().getSimpleName(), new IgnoreFailedTypeMatcher((ElementMatcher<TypeDescription>)typeInstrumentation.typeMatcher()));
        NamedMatcher classLoaderMatcher = new NamedMatcher(instrumentationModule.getClass().getSimpleName() + "#" + typeInstrumentation.getClass().getSimpleName(), moduleClassLoaderMatcher.and(typeInstrumentation.classLoaderOptimization()));
        return (AgentBuilder.Identified.Narrowable)agentBuilder.type(new LoggingFailSafeMatcher<TypeDescription>(typeMatcher, "Instrumentation type matcher unexpected exception: " + typeMatcher), new LoggingFailSafeMatcher(classLoaderMatcher, "Instrumentation class loader matcher unexpected exception: " + classLoaderMatcher)).and((typeDescription, classLoader, module, classBeingRedefined, protectionDomain) -> classLoader == null || NOT_DECORATOR_MATCHER.matches((Object)typeDescription));
    }
}

