/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.tooling.instrumentation.indy.ForceDynamicallyTypedAssignReturnedFactory;
import javax.annotation.Nonnull;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.pool.TypePool;
import org.jetbrains.annotations.NotNull;

class AdviceUninliningPoolStrategy
implements AgentBuilder.PoolStrategy {
    private final AgentBuilder.PoolStrategy poolStrategy;

    public AdviceUninliningPoolStrategy(AgentBuilder.PoolStrategy poolStrategy) {
        this.poolStrategy = poolStrategy;
    }

    @NotNull
    public TypePool typePool(@NotNull ClassFileLocator classFileLocator, ClassLoader classLoader) {
        TypePool typePool = this.poolStrategy.typePool(classFileLocator, classLoader);
        return new TypePoolWrapper(typePool);
    }

    @NotNull
    public TypePool typePool(@NotNull ClassFileLocator classFileLocator, ClassLoader classLoader, @NotNull String name) {
        TypePool typePool = this.poolStrategy.typePool(classFileLocator, classLoader, name);
        return new TypePoolWrapper(typePool);
    }

    private static class TypePoolWrapper
    implements TypePool {
        private final TypePool typePool;

        TypePoolWrapper(TypePool typePool) {
            this.typePool = typePool;
        }

        @NotNull
        public TypePool.Resolution describe(@NotNull String name) {
            final TypePool.Resolution resolution = this.typePool.describe(name);
            return new TypePool.Resolution(){

                public boolean isResolved() {
                    return resolution.isResolved();
                }

                @NotNull
                public TypeDescription resolve() {
                    final TypeDescription typeDescription = resolution.resolve();
                    return new TypeDescription.AbstractBase.OfSimpleType.WithDelegation(){

                        @NotNull
                        public String getName() {
                            return typeDescription.getName();
                        }

                        @NotNull
                        protected TypeDescription delegate() {
                            return typeDescription;
                        }

                        @NotNull
                        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
                            final MethodList methods = super.getDeclaredMethods();
                            class MethodListWrapper
                            extends MethodList.AbstractBase<MethodDescription.InDefinedShape> {
                                MethodListWrapper() {
                                }

                                public MethodDescription.InDefinedShape get(int index) {
                                    return new MethodDescriptionWrapper((MethodDescription.InDefinedShape)methods.get(index));
                                }

                                public int size() {
                                    return methods.size();
                                }
                            }
                            return new MethodListWrapper();
                        }
                    };
                }
            };
        }

        public void clear() {
            this.typePool.clear();
        }
    }

    private static class DelegatingMethodDescription
    extends MethodDescription.InDefinedShape.AbstractBase {
        final MethodDescription.InDefinedShape method;

        DelegatingMethodDescription(MethodDescription.InDefinedShape method) {
            this.method = method;
        }

        @Nonnull
        public TypeDescription getDeclaringType() {
            return this.method.getDeclaringType();
        }

        @NotNull
        public TypeDescription.Generic getReturnType() {
            return this.method.getReturnType();
        }

        @NotNull
        public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
            return this.method.getParameters();
        }

        @NotNull
        public TypeList.Generic getExceptionTypes() {
            return this.method.getExceptionTypes();
        }

        public AnnotationValue<?, ?> getDefaultValue() {
            return this.method.getDefaultValue();
        }

        @NotNull
        public String getInternalName() {
            return this.method.getInternalName();
        }

        @NotNull
        public TypeList.Generic getTypeVariables() {
            return this.method.getTypeVariables();
        }

        public int getModifiers() {
            return this.method.getModifiers();
        }

        @NotNull
        public AnnotationList getDeclaredAnnotations() {
            return this.method.getDeclaredAnnotations();
        }
    }

    private static class MethodDescriptionWrapper
    extends DelegatingMethodDescription {
        MethodDescriptionWrapper(MethodDescription.InDefinedShape method) {
            super(method);
        }

        @Override
        @NotNull
        public AnnotationList getDeclaredAnnotations() {
            final AnnotationList annotations = this.method.getDeclaredAnnotations();
            class AnnotationListWrapper
            extends AnnotationList.AbstractBase {
                AnnotationListWrapper() {
                }

                public AnnotationDescription get(int index) {
                    AnnotationDescription annotation = (AnnotationDescription)annotations.get(index);
                    String annotationTypeName = annotation.getAnnotationType().getActualName();
                    if (!Advice.OnMethodEnter.class.getName().equals(annotationTypeName) && !Advice.OnMethodExit.class.getName().equals(annotationTypeName)) {
                        return annotation;
                    }
                    return ForceDynamicallyTypedAssignReturnedFactory.replaceAnnotationValue(annotation, "inline", oldVal -> AnnotationValue.ForConstant.of((boolean)false));
                }

                public int size() {
                    return annotations.size();
                }
            }
            return new AnnotationListWrapper();
        }
    }
}

