/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.instrumentation.internal.ExperimentalInstrumentationModule;
import io.opentelemetry.javaagent.tooling.bytebuddy.ExceptionHandlers;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.AdviceTransformer;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.AdviceUninliningPoolStrategy;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.ForceDynamicallyTypedAssignReturnedFactory;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyBootstrap;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.InstrumentationModuleClassLoader;
import java.io.FileOutputStream;
import java.io.IOException;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.matcher.ElementMatcher;

public final class IndyTypeTransformerImpl
implements TypeTransformer {
    private static final String DUMP_PATH = null;
    private final Advice.WithCustomMapping adviceMapping;
    private AgentBuilder.Identified.Extendable agentBuilder;
    private final InstrumentationModule instrumentationModule;
    private final boolean transformAdvice;

    public IndyTypeTransformerImpl(AgentBuilder.Identified.Extendable agentBuilder, InstrumentationModule module) {
        this.agentBuilder = agentBuilder;
        this.instrumentationModule = module;
        this.transformAdvice = !(this.instrumentationModule instanceof ExperimentalInstrumentationModule) || !((ExperimentalInstrumentationModule)this.instrumentationModule).isIndyReady();
        this.adviceMapping = Advice.withCustomMapping().with((Advice.PostProcessor.Factory)new ForceDynamicallyTypedAssignReturnedFactory(new Advice.AssignReturned.Factory().withSuppressed(Throwable.class))).bootstrap(IndyBootstrap.getIndyBootstrapMethod(), IndyBootstrap.getAdviceBootstrapArguments(this.instrumentationModule), (TypeDescription.Generic.Visitor)TypeDescription.Generic.Visitor.Generalizing.INSTANCE);
    }

    public void applyAdviceToMethod(ElementMatcher<? super MethodDescription> methodMatcher, String adviceClassName) {
        AgentBuilder.PoolStrategy.Default poolStrategy = AgentBuilder.PoolStrategy.Default.FAST;
        this.agentBuilder = this.agentBuilder.transform((AgentBuilder.Transformer)new AgentBuilder.Transformer.ForAdvice(this.adviceMapping).advice(methodMatcher, adviceClassName).with((AgentBuilder.PoolStrategy)(this.transformAdvice ? poolStrategy : new AdviceUninliningPoolStrategy((AgentBuilder.PoolStrategy)poolStrategy))).include(new ClassFileLocator[]{this.getAdviceLocator(this.instrumentationModule.getClass().getClassLoader())}).withExceptionHandler(ExceptionHandlers.defaultExceptionHandler()));
    }

    private ClassFileLocator getAdviceLocator(ClassLoader classLoader) {
        ClassFileLocator classFileLocator = ClassFileLocator.ForClassLoader.of((ClassLoader)classLoader);
        return this.transformAdvice ? new AdviceLocator(classFileLocator) : classFileLocator;
    }

    public void applyTransformer(AgentBuilder.Transformer transformer) {
        this.agentBuilder = this.agentBuilder.transform(transformer);
    }

    public AgentBuilder.Identified.Extendable getAgentBuilder() {
        return this.agentBuilder;
    }

    private static void dump(String name, byte[] bytes) {
        if (DUMP_PATH == null) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(DUMP_PATH + name.replace('/', '.') + ".class");){
            fos.write(bytes);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class AdviceLocator
    implements ClassFileLocator {
        private final ClassFileLocator delegate;

        AdviceLocator(ClassFileLocator delegate) {
            this.delegate = delegate;
        }

        public ClassFileLocator.Resolution locate(String name) throws IOException {
            ClassFileLocator.Resolution resolution = this.delegate.locate(name);
            return new AdviceTransformingResolution(name, resolution);
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static class AdviceTransformingResolution
    implements ClassFileLocator.Resolution {
        private final String name;
        private final ClassFileLocator.Resolution delegate;

        AdviceTransformingResolution(String name, ClassFileLocator.Resolution delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        public boolean isResolved() {
            return this.delegate.isResolved();
        }

        public byte[] resolve() {
            byte[] bytes = this.delegate.resolve();
            byte[] result = AdviceTransformer.transform(bytes);
            if (result != null) {
                IndyTypeTransformerImpl.dump(this.name, result);
                InstrumentationModuleClassLoader.bytecodeOverride.put(this.name.replace('/', '.'), result);
            } else {
                result = bytes;
            }
            return result;
        }
    }
}

