/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.tooling.instrumentation.indy.AdviceTransformer;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.OriginalDescriptor;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;

class AdviceSignatureEraser {
    private static final Pattern TYPE_REFERENCE_PATTERN = Pattern.compile("L[^;]+;");
    public static final String ORIGNINAL_DESCRIPTOR_ANNOTATION_TYPE = "L" + OriginalDescriptor.class.getName().replace('.', '/') + ";";

    private AdviceSignatureEraser() {
    }

    static byte[] transform(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(cr, 0);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 0);
        final Set<String> methodsToTransform = AdviceSignatureEraser.listAdviceMethods(classNode);
        if (methodsToTransform.isEmpty()) {
            return bytes;
        }
        ClassVisitor cv = new ClassVisitor(589824, (ClassVisitor)cw){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                if (methodsToTransform.contains(name + descriptor)) {
                    String erased = AdviceSignatureEraser.eraseTypes(descriptor);
                    MethodVisitor visitor = super.visitMethod(access, name, erased, null, exceptions);
                    AnnotationVisitor av = visitor.visitAnnotation(ORIGNINAL_DESCRIPTOR_ANNOTATION_TYPE, false);
                    av.visit("value", (Object)descriptor);
                    av.visitEnd();
                    return visitor;
                }
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
        };
        classNode.accept(cv);
        return cw.toByteArray();
    }

    private static String eraseTypes(String descriptor) {
        Matcher matcher = TYPE_REFERENCE_PATTERN.matcher(descriptor);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String reference = matcher.group();
            if (reference.startsWith("Ljava/")) {
                matcher.appendReplacement(result, reference);
                continue;
            }
            matcher.appendReplacement(result, "Ljava/lang/Object;");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static Set<String> listAdviceMethods(ClassNode classNode) {
        return classNode.methods.stream().filter(mn -> AdviceTransformer.hasAnnotation(mn, AdviceTransformer.ADVICE_ON_METHOD_ENTER) || AdviceTransformer.hasAnnotation(mn, AdviceTransformer.ADVICE_ON_METHOD_EXIT)).map(mn -> mn.name + mn.desc).collect(Collectors.toSet());
    }
}

