/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.util;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;

class ClassLoaderMap {
    private static final Cache<ClassLoader, WeakReference<Map<Object, Object>>> data = Cache.weak();
    private static final ClassLoader BOOT_LOADER = new ClassLoader(null){};

    public static Object get(ClassLoader classLoader, Object key) {
        return ClassLoaderMap.getClassLoaderData(classLoader, false).get(key);
    }

    public static void put(ClassLoader classLoader, Object key, Object value) {
        ClassLoaderMap.getClassLoaderData(classLoader, true).put(key, value);
    }

    private static Map<Object, Object> getClassLoaderData(ClassLoader classLoader, boolean initialize) {
        Map<Object, Object> map;
        WeakReference weakReference = (WeakReference)data.get((Object)(classLoader = ClassLoaderMap.maskNullClassLoader(classLoader)));
        Map<Object, Object> map2 = map = weakReference != null ? (Map<Object, Object>)weakReference.get() : null;
        if (map == null) {
            if (!initialize) {
                return Collections.emptyMap();
            }
            map = ClassLoaderMap.createMap(classLoader);
            data.put((Object)classLoader, new WeakReference<Map<Object, Object>>(map));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Object, Object> createMap(ClassLoader classLoader) {
        ConcurrentHashMap<Object, Object> map;
        Class clazz = new ByteBuddy().subclass(Object.class).name("io.opentelemetry.javaagent.ClassLoaderData$$" + Integer.toHexString(System.identityHashCode(classLoader))).defineField("data", Object.class, new ModifierContributor.ForField[]{Ownership.STATIC, Visibility.PUBLIC}).make().load(classLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION.allowExistingTypes()).getLoaded();
        try {
            Field field = clazz.getField("data");
            ClassLoader classLoader2 = classLoader;
            synchronized (classLoader2) {
                map = (ConcurrentHashMap<Object, Object>)field.get(classLoader);
                if (map == null) {
                    map = new ConcurrentHashMap<Object, Object>();
                    field.set(null, map);
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return map;
    }

    private static ClassLoader maskNullClassLoader(ClassLoader classLoader) {
        return classLoader == null ? BOOT_LOADER : classLoader;
    }

    private ClassLoaderMap() {
    }
}

