/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

import io.opentelemetry.instrumentation.api.field.VirtualField;
import io.opentelemetry.instrumentation.api.internal.RuntimeVirtualFieldSupplier;
import io.opentelemetry.javaagent.tooling.field.GeneratedVirtualFieldNames;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class RuntimeFieldBasedImplementationSupplier
implements RuntimeVirtualFieldSupplier.VirtualFieldSupplier {
    RuntimeFieldBasedImplementationSupplier() {
    }

    public <U extends T, T, F> VirtualField<U, F> find(Class<T> type, Class<F> fieldType) {
        try {
            String virtualFieldImplClassName = GeneratedVirtualFieldNames.getVirtualFieldImplementationClassName(type.getName(), fieldType.getName());
            Class<?> contextStoreClass = Class.forName(virtualFieldImplClassName, false, null);
            Method method = contextStoreClass.getMethod("getVirtualField", Class.class, Class.class);
            return (VirtualField)method.invoke(null, type, fieldType);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("VirtualField not found", exception);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException("Failed to get VirtualField", exception);
        }
    }
}

