/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.asyncannotationsupport;

import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategies;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategy;
import io.opentelemetry.instrumentation.api.annotation.support.async.Jdk8AsyncOperationEndStrategy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class WeakRefAsyncOperationEndStrategies
extends AsyncOperationEndStrategies {
    private final List<WeakReference<AsyncOperationEndStrategy>> strategies = new CopyOnWriteArrayList<WeakReference<AsyncOperationEndStrategy>>();

    public static void initialize() {
        AsyncOperationEndStrategies.internalSetStrategiesStorage((AsyncOperationEndStrategies)new WeakRefAsyncOperationEndStrategies());
    }

    private WeakRefAsyncOperationEndStrategies() {
        this.registerStrategy((AsyncOperationEndStrategy)Jdk8AsyncOperationEndStrategy.INSTANCE);
    }

    public void registerStrategy(AsyncOperationEndStrategy strategy) {
        this.strategies.add(new WeakReference<AsyncOperationEndStrategy>(strategy));
    }

    public void unregisterStrategy(AsyncOperationEndStrategy strategy) {
        ListIterator<WeakReference<AsyncOperationEndStrategy>> it = this.strategies.listIterator();
        while (it.hasNext()) {
            AsyncOperationEndStrategy s = (AsyncOperationEndStrategy)it.next().get();
            if (s != null && s != strategy) continue;
            it.remove();
            break;
        }
    }

    public @Nullable AsyncOperationEndStrategy resolveStrategy(Class<?> returnType) {
        ListIterator<WeakReference<AsyncOperationEndStrategy>> it = this.strategies.listIterator();
        while (it.hasNext()) {
            AsyncOperationEndStrategy s = (AsyncOperationEndStrategy)it.next().get();
            if (s == null) {
                it.remove();
                continue;
            }
            if (!s.supports(returnType)) continue;
            return s;
        }
        return null;
    }
}

