/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementations;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementationsGenerator;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappings;
import java.lang.reflect.Method;
import java.util.logging.Level;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.pool.TypePool;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class VirtualFieldFindRewriter
implements AsmVisitorWrapper {
    private static final TransformSafeLogger logger = TransformSafeLogger.getLogger(VirtualFieldFindRewriter.class);
    private static final Method FIND_VIRTUAL_FIELD_METHOD;
    private static final Method FIND_VIRTUAL_FIELD_IMPL_METHOD;
    private final Class<?> instrumentationModuleClass;
    private final VirtualFieldMappings virtualFieldMappings;
    private final VirtualFieldImplementations virtualFieldImplementations;

    public VirtualFieldFindRewriter(Class<?> instrumentationModuleClass, VirtualFieldMappings virtualFieldMappings, VirtualFieldImplementations virtualFieldImplementations) {
        this.instrumentationModuleClass = instrumentationModuleClass;
        this.virtualFieldMappings = virtualFieldMappings;
        this.virtualFieldImplementations = virtualFieldImplementations;
    }

    public int mergeWriter(int flags) {
        return flags | 1;
    }

    @CanIgnoreReturnValue
    public int mergeReader(int flags) {
        return flags;
    }

    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new ClassVisitor(458752, classVisitor){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                return new MethodVisitor(458752, mv){
                    private final Object[] stack;
                    private final int[] insnStack;
                    {
                        this.stack = new Object[]{null, null};
                        this.insnStack = new int[]{-1, -1, -1};
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        this.pushOpcode(opcode);
                        if (Utils.getInternalName(FIND_VIRTUAL_FIELD_METHOD.getDeclaringClass()).equals(owner) && FIND_VIRTUAL_FIELD_METHOD.getName().equals(name) && Type.getMethodDescriptor((Method)FIND_VIRTUAL_FIELD_METHOD).equals(descriptor)) {
                            logger.log(Level.FINEST, "Found VirtualField#find() access in {0}", (Object)VirtualFieldFindRewriter.this.instrumentationModuleClass.getName());
                            if (this.insnStack[0] == 184 && this.insnStack[1] == 18 && this.insnStack[2] == 18 && this.stack[0] instanceof Type && this.stack[1] instanceof Type) {
                                String fieldTypeName = ((Type)this.stack[0]).getClassName();
                                String typeName = ((Type)this.stack[1]).getClassName();
                                TypeDescription virtualFieldImplementationClass = VirtualFieldFindRewriter.this.virtualFieldImplementations.find(typeName, fieldTypeName);
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.log(Level.FINEST, "Rewriting VirtualField#find() for instrumenter {0}: {1} -> {2}", new Object[]{VirtualFieldFindRewriter.this.instrumentationModuleClass.getName(), typeName, fieldTypeName});
                                }
                                if (virtualFieldImplementationClass == null) {
                                    throw new IllegalStateException(String.format("Incorrect VirtualField usage detected. Cannot find implementation for VirtualField<%s, %s>. Was that field registered in %s#registerMuzzleVirtualFields()?", typeName, fieldTypeName, VirtualFieldFindRewriter.this.instrumentationModuleClass.getName()));
                                }
                                if (!VirtualFieldFindRewriter.this.virtualFieldMappings.hasMapping(typeName, fieldTypeName)) {
                                    throw new IllegalStateException(String.format("Incorrect VirtualField usage detected. Cannot find mapping for VirtualField<%s, %s>. Was that field registered in %s#registerMuzzleVirtualFields()?", typeName, fieldTypeName, VirtualFieldFindRewriter.this.instrumentationModuleClass.getName()));
                                }
                                this.mv.visitMethodInsn(184, virtualFieldImplementationClass.getInternalName(), FIND_VIRTUAL_FIELD_IMPL_METHOD.getName(), Type.getMethodDescriptor((Method)FIND_VIRTUAL_FIELD_IMPL_METHOD), false);
                                return;
                            }
                            throw new IllegalStateException("Incorrect VirtualField usage detected. Type and field type must be class-literals. Example of correct usage: VirtualField.find(Runnable.class, RunnableContext.class)");
                        }
                        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                    }

                    private void pushOpcode(int opcode) {
                        System.arraycopy(this.insnStack, 0, this.insnStack, 1, this.insnStack.length - 1);
                        this.insnStack[0] = opcode;
                    }

                    private void pushStack(Object o) {
                        System.arraycopy(this.stack, 0, this.stack, 1, this.stack.length - 1);
                        this.stack[0] = o;
                    }

                    public void visitInsn(int opcode) {
                        this.pushOpcode(opcode);
                        super.visitInsn(opcode);
                    }

                    public void visitJumpInsn(int opcode, Label label) {
                        this.pushOpcode(opcode);
                        super.visitJumpInsn(opcode, label);
                    }

                    public void visitIntInsn(int opcode, int operand) {
                        this.pushOpcode(opcode);
                        super.visitIntInsn(opcode, operand);
                    }

                    public void visitVarInsn(int opcode, int var) {
                        this.pushOpcode(opcode);
                        this.pushStack(var);
                        super.visitVarInsn(opcode, var);
                    }

                    public void visitLdcInsn(Object value) {
                        this.pushOpcode(18);
                        this.pushStack(value);
                        super.visitLdcInsn(value);
                    }
                };
            }
        };
    }

    static {
        try {
            FIND_VIRTUAL_FIELD_METHOD = VirtualField.class.getMethod("find", Class.class, Class.class);
            FIND_VIRTUAL_FIELD_IMPL_METHOD = VirtualFieldImplementationsGenerator.VirtualFieldImplementationTemplate.class.getMethod("getVirtualField", Class.class, Class.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

