/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.bytebuddy;

import io.opentelemetry.javaagent.bootstrap.ExceptionLogger;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public final class ExceptionHandlers {
    private static final String LOGGER_NAME = ExceptionLogger.class.getName().replace('.', '/');
    private static final Advice.ExceptionHandler EXCEPTION_STACK_HANDLER = new Advice.ExceptionHandler.Simple(new StackManipulation(){
        private final StackManipulation.Size size = new StackManipulation.Size(-1, 2);

        public boolean isValid() {
            return true;
        }

        public StackManipulation.Size apply(MethodVisitor mv, Implementation.Context context) {
            String name = context.getInstrumentedType().getName();
            Label logStart = new Label();
            Label logEnd = new Label();
            Label eatException = new Label();
            Label handlerExit = new Label();
            boolean frames = context.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V6);
            mv.visitTryCatchBlock(logStart, logEnd, eatException, "java/lang/Throwable");
            mv.visitLabel(logStart);
            mv.visitLdcInsn((Object)("Failed to handle exception in instrumentation for " + name));
            mv.visitInsn(95);
            mv.visitMethodInsn(184, LOGGER_NAME, "logSuppressedError", "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
            mv.visitLabel(logEnd);
            mv.visitJumpInsn(167, handlerExit);
            mv.visitLabel(eatException);
            if (frames) {
                mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
            }
            mv.visitInsn(87);
            mv.visitLabel(handlerExit);
            if (frames) {
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitInsn(0);
            }
            return this.size;
        }
    });

    public static Advice.ExceptionHandler defaultExceptionHandler() {
        return EXCEPTION_STACK_HANDLER;
    }

    private ExceptionHandlers() {
    }
}

