/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.tooling.instrumentation.indy.ClassCopySource;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.LookupExposer;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class InstrumentationModuleClassLoader
extends ClassLoader {
    private static final Map<String, ClassCopySource> ALWAYS_INJECTED_CLASSES;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final MethodHandle FIND_PACKAGE_METHOD;
    private final Map<String, ClassCopySource> additionalInjectedClasses;
    private final ClassLoader agentOrExtensionCl;
    private final ClassLoader instrumentedCl;
    private volatile MethodHandles.Lookup cachedLookup;

    public InstrumentationModuleClassLoader(ClassLoader instrumentedCl, ClassLoader agentOrExtensionCl, Map<String, ClassCopySource> injectedClasses) {
        super(agentOrExtensionCl);
        this.additionalInjectedClasses = injectedClasses;
        this.agentOrExtensionCl = agentOrExtensionCl;
        this.instrumentedCl = instrumentedCl;
    }

    public MethodHandles.Lookup getLookup() {
        if (this.cachedLookup == null) {
            try {
                Class<?> lookupExposer = this.loadClass(LookupExposer.class.getName());
                this.cachedLookup = (MethodHandles.Lookup)lookupExposer.getMethod("getLookup", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.cachedLookup;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            ClassCopySource injected;
            Class<Object> result = this.findLoadedClass(name);
            if (result == null && (injected = this.getInjectedClass(name)) != null) {
                byte[] bytecode = injected.getBytecode();
                result = System.getSecurityManager() == null ? this.defineClassWithPackage(name, bytecode) : AccessController.doPrivileged(() -> this.defineClassWithPackage(name, bytecode));
            }
            if (result == null) {
                result = InstrumentationModuleClassLoader.tryLoad(this.agentOrExtensionCl, name);
            }
            if (result == null) {
                result = InstrumentationModuleClassLoader.tryLoad(this.instrumentedCl, name);
            }
            if (result != null) {
                if (resolve) {
                    this.resolveClass(result);
                }
                return result;
            }
            throw new ClassNotFoundException(name);
        }
    }

    private static Class<?> tryLoad(ClassLoader cl, String name) {
        try {
            return cl.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public URL getResource(String resourceName) {
        String className = InstrumentationModuleClassLoader.resourceToClassName(resourceName);
        if (className == null) {
            return super.getResource(resourceName);
        }
        ClassCopySource injected = this.getInjectedClass(className);
        if (injected != null) {
            return injected.getUrl();
        }
        URL fromAgentCl = this.agentOrExtensionCl.getResource(resourceName);
        if (fromAgentCl != null) {
            return fromAgentCl;
        }
        return this.instrumentedCl.getResource(resourceName);
    }

    @Override
    public Enumeration<URL> getResources(String resourceName) throws IOException {
        String className = InstrumentationModuleClassLoader.resourceToClassName(resourceName);
        if (className == null) {
            return super.getResources(resourceName);
        }
        URL resource = this.getResource(resourceName);
        List<Object> result = resource != null ? Collections.singletonList(resource) : Collections.emptyList();
        return Collections.enumeration(result);
    }

    @Nullable
    private static String resourceToClassName(String resourceName) {
        if (!resourceName.endsWith(".class")) {
            return null;
        }
        String className = resourceName;
        if (className.startsWith("/")) {
            className = className.substring(1);
        }
        className = className.replace('/', '.');
        className = className.substring(0, className.length() - ".class".length());
        return className;
    }

    @Nullable
    private ClassCopySource getInjectedClass(String name) {
        ClassCopySource alwaysInjected = ALWAYS_INJECTED_CLASSES.get(name);
        if (alwaysInjected != null) {
            return alwaysInjected;
        }
        return this.additionalInjectedClasses.get(name);
    }

    private Class<?> defineClassWithPackage(String name, byte[] bytecode) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex != -1) {
            String packageName = name.substring(0, lastDotIndex);
            this.safeDefinePackage(packageName);
        }
        return this.defineClass(name, bytecode, 0, bytecode.length, PROTECTION_DOMAIN);
    }

    private void safeDefinePackage(String packageName) {
        block3: {
            if (this.findPackage(packageName) == null) {
                try {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException e) {
                    if (this.findPackage(packageName) != null) break block3;
                    throw e;
                }
            }
        }
    }

    Package findPackage(String name) {
        try {
            return FIND_PACKAGE_METHOD.invoke(this, name);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    private static ProtectionDomain getProtectionDomain() {
        if (System.getSecurityManager() == null) {
            return InstrumentationModuleClassLoader.class.getProtectionDomain();
        }
        return AccessController.doPrivileged(InstrumentationModuleClassLoader.class::getProtectionDomain);
    }

    private static MethodHandle getFindPackageMethod() {
        MethodType methodType = MethodType.methodType(Package.class, String.class);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findVirtual(ClassLoader.class, "getDefinedPackage", methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            try {
                return lookup.findVirtual(ClassLoader.class, "getPackage", methodType);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("expected method to always exist!", ex);
            }
            catch (IllegalAccessException ex2) {
                throw new IllegalStateException("Method should be accessible from here", ex2);
            }
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
        ALWAYS_INJECTED_CLASSES = Collections.singletonMap(LookupExposer.class.getName(), ClassCopySource.create(LookupExposer.class).cached());
        PROTECTION_DOMAIN = InstrumentationModuleClassLoader.getProtectionDomain();
        FIND_PACKAGE_METHOD = InstrumentationModuleClassLoader.getFindPackageMethod();
    }
}

