/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.auto.service.AutoService;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.javaagent.instrumentation.api.OpenTelemetrySdkAccess;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetrySdkAutoConfiguration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={AgentListener.class})
public class OpenTelemetryInstaller
implements AgentListener {
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryInstaller.class);
    static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";

    public void beforeAgent(Config config) {
        OpenTelemetryInstaller.installAgentTracer(config);
    }

    public static synchronized void installAgentTracer(Config config) {
        if (config.getBooleanProperty(JAVAAGENT_ENABLED_CONFIG, true)) {
            OpenTelemetryInstaller.copySystemProperties(config);
            OpenTelemetrySdk sdk = OpenTelemetrySdkAutoConfiguration.initialize();
            OpenTelemetrySdkAccess.internalSetForceFlush((timeout, unit) -> sdk.getSdkTracerProvider().forceFlush().join((long)timeout, unit));
        } else {
            log.info("Tracing is disabled.");
        }
    }

    private static void copySystemProperties(Config config) {
        Map allProperties = config.getAllProperties();
        Map environmentProperties = Config.newBuilder().readEnvironmentVariables().readSystemProperties().build().getAllProperties();
        allProperties.forEach((key, value) -> {
            if (!environmentProperties.containsKey(key) && key.startsWith("otel.") && !key.startsWith("otel.instrumentation")) {
                System.setProperty(key, value);
            }
        });
    }
}

