/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.collector;

import com.google.common.collect.EvictingQueue;
import io.opentelemetry.javaagent.extension.muzzle.Reference;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationClassPredicate;
import io.opentelemetry.javaagent.tooling.muzzle.collector.MuzzleCompilationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;

class ReferenceCollectingClassVisitor
extends ClassVisitor {
    private final InstrumentationClassPredicate instrumentationClassPredicate;
    private final boolean isAdviceClass;
    private final Map<String, Reference> references = new LinkedHashMap<String, Reference>();
    private final Set<String> helperClasses = new HashSet<String>();
    private final Set<String> helperSuperClasses = new HashSet<String>();
    private final Map<String, String> contextStoreClasses = new LinkedHashMap<String, String>();
    private String refSourceClassName;
    private Type refSourceType;

    private static String internalPackageName(String internalName) {
        return internalName.replaceAll("/[^/]+$", "");
    }

    private static Reference.Flag.MinimumVisibilityFlag computeMinimumClassAccess(Type from, Type to) {
        if (from.getInternalName().equalsIgnoreCase(to.getInternalName())) {
            return Reference.Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER;
        }
        if (ReferenceCollectingClassVisitor.internalPackageName(from.getInternalName()).equals(ReferenceCollectingClassVisitor.internalPackageName(to.getInternalName()))) {
            return Reference.Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER;
        }
        return Reference.Flag.MinimumVisibilityFlag.PUBLIC;
    }

    private static Reference.Flag.MinimumVisibilityFlag computeMinimumFieldAccess(Type from, Type to) {
        if (from.getInternalName().equalsIgnoreCase(to.getInternalName())) {
            return Reference.Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER;
        }
        if (ReferenceCollectingClassVisitor.internalPackageName(from.getInternalName()).equals(ReferenceCollectingClassVisitor.internalPackageName(to.getInternalName()))) {
            return Reference.Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER;
        }
        return Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER;
    }

    private static Reference.Flag.MinimumVisibilityFlag computeMinimumMethodAccess(Type from, Type to, Type methodType) {
        if (from.getInternalName().equalsIgnoreCase(to.getInternalName())) {
            return Reference.Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER;
        }
        return Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER;
    }

    private static Type underlyingType(Type type) {
        while (type.getSort() == 9) {
            type = type.getElementType();
        }
        return type;
    }

    ReferenceCollectingClassVisitor(InstrumentationClassPredicate instrumentationClassPredicate, boolean isAdviceClass) {
        super(458752);
        this.instrumentationClassPredicate = instrumentationClassPredicate;
        this.isAdviceClass = isAdviceClass;
    }

    Map<String, Reference> getReferences() {
        return this.references;
    }

    Set<String> getHelperClasses() {
        return this.helperClasses;
    }

    Set<String> getHelperSuperClasses() {
        return this.helperSuperClasses;
    }

    Map<String, String> getContextStoreClasses() {
        return this.contextStoreClasses;
    }

    private void addExtendsReference(Reference ref) {
        this.addReference(ref);
        if (this.instrumentationClassPredicate.isInstrumentationClass(ref.getClassName())) {
            this.helperSuperClasses.add(ref.getClassName());
        }
    }

    private void addReference(Reference ref) {
        if (!ref.getClassName().startsWith("java.")) {
            Reference reference = this.references.get(ref.getClassName());
            if (null == reference) {
                this.references.put(ref.getClassName(), ref);
            } else {
                this.references.put(ref.getClassName(), reference.merge(ref));
            }
        }
        if (this.instrumentationClassPredicate.isInstrumentationClass(ref.getClassName())) {
            this.helperClasses.add(ref.getClassName());
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.refSourceClassName = Utils.getClassName(name);
        this.refSourceType = Type.getType((String)("L" + name + ";"));
        if (!this.isAdviceClass) {
            String fixedSuperClassName = Utils.getClassName(superName);
            this.addExtendsReference(new Reference.Builder(fixedSuperClassName).withSource(this.refSourceClassName).build());
            ArrayList<String> fixedInterfaceNames = new ArrayList<String>(interfaces.length);
            for (String interfaceName : interfaces) {
                String fixedInterfaceName = Utils.getClassName(interfaceName);
                fixedInterfaceNames.add(fixedInterfaceName);
                this.addExtendsReference(new Reference.Builder(fixedInterfaceName).withSource(this.refSourceClassName).build());
            }
            this.addReference(new Reference.Builder(this.refSourceClassName).withSource(this.refSourceClassName).withSuperName(fixedSuperClassName).withInterfaces(fixedInterfaceNames).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeTypeManifestationFlag(access)).build());
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        Type fieldType = Type.getType((String)descriptor);
        this.addReference(new Reference.Builder(this.refSourceClassName).withSource(this.refSourceClassName).withField(new Reference.Source[0], new Reference.Flag[0], name, fieldType, true).build());
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (!this.isAdviceClass) {
            Type methodType = Type.getMethodType((String)descriptor);
            Reference.Flag.VisibilityFlag visibilityFlag = ReferenceCollectingClassVisitor.computeVisibilityFlag(access);
            Reference.Flag.OwnershipFlag ownershipFlag = ReferenceCollectingClassVisitor.computeOwnershipFlag(access);
            Reference.Flag.ManifestationFlag manifestationFlag = ReferenceCollectingClassVisitor.computeTypeManifestationFlag(access);
            this.addReference(new Reference.Builder(this.refSourceClassName).withSource(this.refSourceClassName).withMethod(new Reference.Source[0], new Reference.Flag[]{visibilityFlag, ownershipFlag, manifestationFlag}, name, methodType.getReturnType(), methodType.getArgumentTypes()).build());
        }
        return new AdviceReferenceMethodVisitor(new InstrumentationContextMethodVisitor(super.visitMethod(access, name, descriptor, signature, exceptions)));
    }

    private static Reference.Flag.VisibilityFlag computeVisibilityFlag(int access) {
        if (Reference.Flag.VisibilityFlag.PUBLIC.matches(access)) {
            return Reference.Flag.VisibilityFlag.PUBLIC;
        }
        if (Reference.Flag.VisibilityFlag.PROTECTED.matches(access)) {
            return Reference.Flag.VisibilityFlag.PROTECTED;
        }
        if (Reference.Flag.VisibilityFlag.PACKAGE.matches(access)) {
            return Reference.Flag.VisibilityFlag.PACKAGE;
        }
        return Reference.Flag.VisibilityFlag.PRIVATE;
    }

    private static Reference.Flag.OwnershipFlag computeOwnershipFlag(int access) {
        if (Reference.Flag.OwnershipFlag.STATIC.matches(access)) {
            return Reference.Flag.OwnershipFlag.STATIC;
        }
        return Reference.Flag.OwnershipFlag.NON_STATIC;
    }

    private static Reference.Flag.ManifestationFlag computeTypeManifestationFlag(int access) {
        if (Reference.Flag.ManifestationFlag.ABSTRACT.matches(access)) {
            return Reference.Flag.ManifestationFlag.ABSTRACT;
        }
        if (Reference.Flag.ManifestationFlag.FINAL.matches(access)) {
            return Reference.Flag.ManifestationFlag.FINAL;
        }
        return Reference.Flag.ManifestationFlag.NON_FINAL;
    }

    private class InstrumentationContextMethodVisitor
    extends MethodVisitor {
        private final EvictingQueue<String> lastTwoClassConstants;

        InstrumentationContextMethodVisitor(MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.lastTwoClassConstants = EvictingQueue.create((int)2);
        }

        public void visitInsn(int opcode) {
            this.registerOpcode(opcode, null);
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.registerOpcode(opcode, null);
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.registerOpcode(opcode, null);
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            this.registerOpcode(opcode, null);
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            this.registerOpcode(opcode, null);
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            Type methodType = Type.getMethodType((String)descriptor);
            Type ownerType = Type.getType((String)("L" + owner + ";"));
            if ("io.opentelemetry.javaagent.instrumentation.api.InstrumentationContext".equals(ownerType.getClassName()) && "get".equals(name) && methodType.getArgumentTypes().length == 2) {
                if (this.lastTwoClassConstants.remainingCapacity() == 0) {
                    String className = (String)this.lastTwoClassConstants.poll();
                    String contextClassName = (String)this.lastTwoClassConstants.poll();
                    ReferenceCollectingClassVisitor.this.contextStoreClasses.put(className, contextClassName);
                } else {
                    throw new MuzzleCompilationException("Invalid InstrumentationContext#get(Class, Class) usage: you cannot pass variables, method parameters, compute classes; class references need to be passed directly to the get() method");
                }
            }
            this.registerOpcode(opcode, null);
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.registerOpcode(opcode, null);
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object value) {
            this.registerOpcode(18, value);
            super.visitLdcInsn(value);
        }

        private void registerOpcode(int opcode, Object value) {
            Type type;
            if (opcode == 18 && value instanceof Type && (type = (Type)value).getSort() == 10) {
                this.lastTwoClassConstants.add((Object)type.getClassName());
                return;
            }
            this.lastTwoClassConstants.poll();
        }
    }

    private class AdviceReferenceMethodVisitor
    extends MethodVisitor {
        private int currentLineNumber;

        public AdviceReferenceMethodVisitor(MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.currentLineNumber = -1;
        }

        public void visitLineNumber(int line, Label start) {
            this.currentLineNumber = line;
            super.visitLineNumber(line, start);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            Type ownerType = owner.startsWith("[") ? ReferenceCollectingClassVisitor.underlyingType(Type.getType((String)owner)) : Type.getType((String)("L" + owner + ";"));
            Type fieldType = Type.getType((String)descriptor);
            ArrayList<Object> fieldFlags = new ArrayList<Object>();
            fieldFlags.add(ReferenceCollectingClassVisitor.computeMinimumFieldAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType));
            fieldFlags.add(opcode == 178 || opcode == 179 ? Reference.Flag.OwnershipFlag.STATIC : Reference.Flag.OwnershipFlag.NON_STATIC);
            ReferenceCollectingClassVisitor.this.addReference(new Reference.Builder(ownerType.getInternalName()).withSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType)).withField(new Reference.Source[]{new Reference.Source(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber)}, fieldFlags.toArray(new Reference.Flag[0]), name, fieldType, false).build());
            Type underlyingFieldType = ReferenceCollectingClassVisitor.underlyingType(fieldType);
            if (underlyingFieldType.getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(new Reference.Builder(underlyingFieldType.getInternalName()).withSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, underlyingFieldType)).build());
            }
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            Type methodType = Type.getMethodType((String)descriptor);
            Type ownerType = owner.startsWith("[") ? ReferenceCollectingClassVisitor.underlyingType(Type.getType((String)owner)) : Type.getType((String)("L" + owner + ";"));
            Type[] returnType = ReferenceCollectingClassVisitor.underlyingType(methodType.getReturnType());
            if (returnType.getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(new Reference.Builder(returnType.getInternalName()).withSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, (Type)returnType)).build());
            }
            for (Type paramType : methodType.getArgumentTypes()) {
                if ((paramType = ReferenceCollectingClassVisitor.underlyingType(paramType)).getSort() != 10) continue;
                ReferenceCollectingClassVisitor.this.addReference(new Reference.Builder(paramType.getInternalName()).withSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, paramType)).build());
            }
            ArrayList<Object> methodFlags = new ArrayList<Object>();
            methodFlags.add(opcode == 184 ? Reference.Flag.OwnershipFlag.STATIC : Reference.Flag.OwnershipFlag.NON_STATIC);
            methodFlags.add(ReferenceCollectingClassVisitor.computeMinimumMethodAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType, methodType));
            ReferenceCollectingClassVisitor.this.addReference(new Reference.Builder(ownerType.getInternalName()).withSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).withFlag((Reference.Flag)(isInterface ? Reference.Flag.ManifestationFlag.INTERFACE : Reference.Flag.ManifestationFlag.NON_INTERFACE)).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType)).withMethod(new Reference.Source[]{new Reference.Source(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber)}, methodFlags.toArray(new Reference.Flag[0]), name, methodType.getReturnType(), methodType.getArgumentTypes()).build());
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitTypeInsn(int opcode, String type) {
            Type typeObj = ReferenceCollectingClassVisitor.underlyingType(Type.getObjectType((String)type));
            if (typeObj.getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(new Reference.Builder(typeObj.getInternalName()).withSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, typeObj)).build());
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            ReferenceCollectingClassVisitor.this.addReference(new Reference.Builder(bootstrapMethodHandle.getOwner()).withSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, Type.getObjectType((String)bootstrapMethodHandle.getOwner()))).build());
            for (Object arg : bootstrapMethodArguments) {
                if (!(arg instanceof Handle)) continue;
                Handle handle = (Handle)arg;
                ReferenceCollectingClassVisitor.this.addReference(new Reference.Builder(handle.getOwner()).withSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, Type.getObjectType((String)handle.getOwner()))).build());
            }
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }

        public void visitLdcInsn(Object value) {
            Type type;
            if (value instanceof Type && (type = ReferenceCollectingClassVisitor.underlyingType((Type)value)).getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(new Reference.Builder(type.getInternalName()).withSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).withFlag((Reference.Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, type)).build());
            }
            super.visitLdcInsn(value);
        }
    }
}

