/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.bytebuddy.ExceptionHandlers;
import io.opentelemetry.javaagent.tooling.context.FieldBackedProvider;
import io.opentelemetry.javaagent.tooling.context.InstrumentationContextProvider;
import io.opentelemetry.javaagent.tooling.context.NoopContextProvider;
import io.opentelemetry.javaagent.tooling.instrumentation.ConstantAdjuster;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.Mismatch;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.ReferenceMatcher;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstrumentationModuleInstaller {
    private static final TransformSafeLogger log = TransformSafeLogger.getLogger(InstrumentationModule.class);
    private static final Logger muzzleLog = LoggerFactory.getLogger((String)"muzzleMatcher");
    public static final ElementMatcher.Junction<AnnotationSource> NOT_DECORATOR_MATCHER = ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"javax.decorator.Decorator")));

    AgentBuilder install(InstrumentationModule instrumentationModule, AgentBuilder parentAgentBuilder) {
        if (!instrumentationModule.isEnabled()) {
            log.debug("Instrumentation {} is disabled", (Object)instrumentationModule.instrumentationName());
            return parentAgentBuilder;
        }
        List<String> helperClassNames = Arrays.asList(instrumentationModule.getMuzzleHelperClassNames());
        List<String> helperResourceNames = Arrays.asList(instrumentationModule.helperResourceNames());
        List typeInstrumentations = instrumentationModule.typeInstrumentations();
        if (typeInstrumentations.isEmpty()) {
            if (!helperClassNames.isEmpty() || !helperResourceNames.isEmpty()) {
                log.warn("Helper classes and resources won't be injected if no types are instrumented: {}", (Object)instrumentationModule.instrumentationName());
            }
            return parentAgentBuilder;
        }
        ElementMatcher.Junction moduleClassLoaderMatcher = instrumentationModule.classLoaderMatcher();
        MuzzleMatcher muzzleMatcher = new MuzzleMatcher(instrumentationModule, helperClassNames);
        HelperInjector helperInjector = new HelperInjector(instrumentationModule.instrumentationName(), helperClassNames, helperResourceNames);
        InstrumentationContextProvider contextProvider = this.createInstrumentationContextProvider(instrumentationModule);
        AgentBuilder agentBuilder = parentAgentBuilder;
        for (TypeInstrumentation typeInstrumentation : typeInstrumentations) {
            AgentBuilder.Identified.Extendable extendableAgentBuilder = ((AgentBuilder.Identified.Narrowable)((AgentBuilder.Identified.Narrowable)agentBuilder.type((ElementMatcher)AgentElementMatchers.failSafe((ElementMatcher)typeInstrumentation.typeMatcher(), (String)("Instrumentation type matcher unexpected exception: " + this.getClass().getName())), (ElementMatcher)AgentElementMatchers.failSafe((ElementMatcher)moduleClassLoaderMatcher.and(typeInstrumentation.classLoaderOptimization()), (String)("Instrumentation class loader matcher unexpected exception: " + this.getClass().getName()))).and(NOT_DECORATOR_MATCHER)).and((AgentBuilder.RawMatcher)muzzleMatcher)).transform(ConstantAdjuster.instance()).transform((AgentBuilder.Transformer)helperInjector);
            extendableAgentBuilder = contextProvider.instrumentationTransformer(extendableAgentBuilder);
            extendableAgentBuilder = this.applyInstrumentationTransformers(typeInstrumentation.transformers(), extendableAgentBuilder);
            extendableAgentBuilder = contextProvider.additionalInstrumentation(extendableAgentBuilder);
            agentBuilder = extendableAgentBuilder;
        }
        return agentBuilder;
    }

    private InstrumentationContextProvider createInstrumentationContextProvider(InstrumentationModule instrumentationModule) {
        Map contextStore = instrumentationModule.getMuzzleContextStoreClasses();
        if (!contextStore.isEmpty()) {
            return new FieldBackedProvider(instrumentationModule.getClass(), contextStore);
        }
        return NoopContextProvider.INSTANCE;
    }

    private AgentBuilder.Identified.Extendable applyInstrumentationTransformers(Map<? extends ElementMatcher<? super MethodDescription>, String> transformers, AgentBuilder.Identified.Extendable agentBuilder) {
        for (Map.Entry<? extends ElementMatcher<? super MethodDescription>, String> entry : transformers.entrySet()) {
            agentBuilder = agentBuilder.transform((AgentBuilder.Transformer)new AgentBuilder.Transformer.ForAdvice().include(new ClassLoader[]{Utils.getBootstrapProxy(), Utils.getAgentClassLoader()}).withExceptionHandler(ExceptionHandlers.defaultExceptionHandler()).advice(entry.getKey(), entry.getValue()));
        }
        return agentBuilder;
    }

    private static class MuzzleMatcher
    implements AgentBuilder.RawMatcher {
        private final InstrumentationModule instrumentationModule;
        private final List<String> helperClassNames;
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private volatile ReferenceMatcher referenceMatcher;

        private MuzzleMatcher(InstrumentationModule instrumentationModule, List<String> helperClassNames) {
            this.instrumentationModule = instrumentationModule;
            this.helperClassNames = helperClassNames;
        }

        public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
            ReferenceMatcher muzzle = this.getReferenceMatcher();
            boolean isMatch = muzzle.matches(classLoader);
            if (!isMatch) {
                if (muzzleLog.isWarnEnabled()) {
                    muzzleLog.warn("Instrumentation skipped, mismatched references were found: {} [class {}] on {}", new Object[]{this.instrumentationModule.instrumentationName(), this.instrumentationModule.getClass().getName(), classLoader});
                    List<Mismatch> mismatches = muzzle.getMismatchedReferenceSources(classLoader);
                    for (Mismatch mismatch : mismatches) {
                        muzzleLog.warn("-- {}", (Object)mismatch);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Applying instrumentation: {} [class {}] on {}", this.instrumentationModule.instrumentationName(), this.instrumentationModule.getClass().getName(), classLoader);
            }
            return isMatch;
        }

        private ReferenceMatcher getReferenceMatcher() {
            if (this.initialized.compareAndSet(false, true)) {
                this.referenceMatcher = new ReferenceMatcher(this.helperClassNames, this.instrumentationModule.getMuzzleReferences(), arg_0 -> ((InstrumentationModule)this.instrumentationModule).isHelperClass(arg_0));
            }
            return this.referenceMatcher;
        }
    }
}

