/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import java.util.Locale;

class LoggingConfigurer {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[opentelemetry.auto.trace 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.defaultLogLevel";
    private static final String SIMPLE_LOGGER_PREFIX = "io.opentelemetry.javaagent.slf4j.simpleLogger.log.";

    LoggingConfigurer() {
    }

    static void configureLogger() {
        LoggingConfigurer.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        LoggingConfigurer.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (LoggingConfigurer.isDebugMode()) {
            LoggingConfigurer.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "DEBUG");
            LoggingConfigurer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.io.perfmark.PerfMark", "INFO");
            LoggingConfigurer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.io.grpc.Context", "INFO");
            LoggingConfigurer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.io.grpc.internal.ServerImplBuilder", "INFO");
            LoggingConfigurer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.io.grpc.internal.ManagedChannelImplBuilder", "INFO");
        } else {
            LoggingConfigurer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.muzzleMatcher", "OFF");
        }
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "otel.javaagent.debug";
        String tracerDebugLevelProp = System.getProperty(tracerDebugLevelSysprop);
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv(tracerDebugLevelSysprop.replace('.', '_').toUpperCase(Locale.ROOT));
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }
}

