/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.instrumentation.api.appender.internal.LogEmitterProvider;
import io.opentelemetry.instrumentation.sdk.appender.internal.DelegatingLogEmitterProvider;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.bootstrap.AgentLogEmitterProvider;
import io.opentelemetry.javaagent.bootstrap.OpenTelemetrySdkAccess;
import io.opentelemetry.javaagent.tooling.config.ConfigurationFileLoader;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.SdkLogEmitterProvider;
import java.util.Arrays;
import java.util.function.Supplier;

public final class OpenTelemetryInstaller {
    static AutoConfiguredOpenTelemetrySdk installOpenTelemetrySdk() {
        AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(true).addPropertiesSupplier((Supplier)new ConfigurationFileLoader());
        ClassLoader classLoader = AgentInitializer.getExtensionsClassLoader();
        if (classLoader != null) {
            builder.setServiceClassLoader(classLoader);
        }
        AutoConfiguredOpenTelemetrySdk autoConfiguredSdk = builder.build();
        OpenTelemetrySdk sdk = autoConfiguredSdk.getOpenTelemetrySdk();
        OpenTelemetrySdkAccess.internalSetForceFlush((timeout, unit) -> {
            CompletableResultCode traceResult = sdk.getSdkTracerProvider().forceFlush();
            CompletableResultCode metricsResult = sdk.getSdkMeterProvider().forceFlush();
            CompletableResultCode.ofAll(Arrays.asList(traceResult, metricsResult)).join((long)timeout, unit);
        });
        SdkLogEmitterProvider sdkLogEmitterProvider = autoConfiguredSdk.getOpenTelemetrySdk().getSdkLogEmitterProvider();
        DelegatingLogEmitterProvider logEmitterProvider = DelegatingLogEmitterProvider.from((SdkLogEmitterProvider)sdkLogEmitterProvider);
        AgentLogEmitterProvider.set((LogEmitterProvider)logEmitterProvider);
        return autoConfiguredSdk;
    }

    private OpenTelemetryInstaller() {
    }
}

