/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.extension.config.ConfigCustomizer;
import io.opentelemetry.javaagent.extension.config.ConfigPropertySource;
import io.opentelemetry.javaagent.tooling.SafeServiceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConfigInitializer {
    private static final Logger logger = Logger.getLogger(ConfigInitializer.class.getName());
    static final String CONFIGURATION_FILE_PROPERTY = "otel.javaagent.configuration-file";
    static final String CONFIGURATION_FILE_ENV_VAR = "OTEL_JAVAAGENT_CONFIGURATION_FILE";

    public static void initialize() {
        List<ConfigCustomizer> customizers = SafeServiceLoader.loadOrdered(ConfigCustomizer.class);
        Config config = ConfigInitializer.create(ConfigInitializer.loadSpiConfiguration(customizers), ConfigInitializer.loadConfigurationFile());
        for (ConfigCustomizer customizer : customizers) {
            config = customizer.customize(config);
        }
        Config.internalInitializeConfig((Config)config);
    }

    static Config create(Properties spiConfiguration, Properties configurationFile) {
        return Config.builder().addProperties(spiConfiguration).addProperties(configurationFile).addEnvironmentVariables().addSystemProperties().build();
    }

    private static Properties loadSpiConfiguration(List<ConfigCustomizer> customizers) {
        Properties propertiesFromSpi = new Properties();
        for (ConfigPropertySource propertySource : SafeServiceLoader.loadOrdered(ConfigPropertySource.class)) {
            propertiesFromSpi.putAll((Map<?, ?>)propertySource.getProperties());
        }
        for (ConfigCustomizer customizer : customizers) {
            propertiesFromSpi.putAll((Map<?, ?>)customizer.defaultProperties());
        }
        return propertiesFromSpi;
    }

    static Properties loadConfigurationFile() {
        Properties properties = new Properties();
        String configurationFilePath = System.getProperty(CONFIGURATION_FILE_PROPERTY);
        if (configurationFilePath == null) {
            configurationFilePath = System.getenv(CONFIGURATION_FILE_ENV_VAR);
        }
        if (configurationFilePath == null) {
            return properties;
        }
        File configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")));
        if (!configurationFile.exists()) {
            logger.log(Level.SEVERE, "Configuration file \"{0}\" not found.", configurationFilePath);
            return properties;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configurationFile), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (FileNotFoundException fnf) {
            logger.log(Level.SEVERE, "Configuration file \"{0}\" not found.", configurationFilePath);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Configuration file \"{0}\" cannot be accessed or correctly parsed.", configurationFilePath);
        }
        return properties;
    }

    private ConfigInitializer() {
    }
}

