/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.tooling.LoggingCustomizer;
import java.util.Locale;

final class DefaultLoggingCustomizer
implements LoggingCustomizer {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[otel.javaagent 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.defaultLogLevel";
    private static final String SIMPLE_LOGGER_PREFIX = "io.opentelemetry.javaagent.slf4j.simpleLogger.log.";

    DefaultLoggingCustomizer() {
    }

    @Override
    public void init() {
        DefaultLoggingCustomizer.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        DefaultLoggingCustomizer.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (DefaultLoggingCustomizer.isDebugMode()) {
            DefaultLoggingCustomizer.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "DEBUG");
            DefaultLoggingCustomizer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.okhttp3.internal.http2", "INFO");
        } else {
            DefaultLoggingCustomizer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.muzzleMatcher", "OFF");
        }
    }

    @Override
    public void onStartupFailure(Throwable throwable) {
        System.err.println("OpenTelemetry Javaagent failed to start");
        throwable.printStackTrace();
    }

    @Override
    public void onStartupSuccess() {
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "otel.javaagent.debug";
        String tracerDebugLevelProp = System.getProperty(tracerDebugLevelSysprop);
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv(tracerDebugLevelSysprop.replace('.', '_').toUpperCase(Locale.ROOT));
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }
}

