/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.extension.instrumentation.HelperResourceBuilder;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.bytebuddy.LoggingFailSafeMatcher;
import io.opentelemetry.javaagent.tooling.config.AgentConfig;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementationInstaller;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementationInstallerFactory;
import io.opentelemetry.javaagent.tooling.instrumentation.ConstantAdjuster;
import io.opentelemetry.javaagent.tooling.instrumentation.MuzzleFailureCounter;
import io.opentelemetry.javaagent.tooling.instrumentation.TypeTransformerImpl;
import io.opentelemetry.javaagent.tooling.muzzle.HelperResourceBuilderImpl;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.Mismatch;
import io.opentelemetry.javaagent.tooling.muzzle.ReferenceMatcher;
import io.opentelemetry.javaagent.tooling.util.IgnoreFailedTypeMatcher;
import io.opentelemetry.javaagent.tooling.util.NamedMatcher;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public final class InstrumentationModuleInstaller {
    private static final TransformSafeLogger logger = TransformSafeLogger.getLogger(InstrumentationModule.class);
    private static final Logger muzzleLogger = Logger.getLogger("muzzleMatcher");
    public static final ElementMatcher.Junction<AnnotationSource> NOT_DECORATOR_MATCHER = ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"javax.decorator.Decorator")));
    private final Instrumentation instrumentation;
    private final VirtualFieldImplementationInstallerFactory virtualFieldInstallerFactory = new VirtualFieldImplementationInstallerFactory();

    public InstrumentationModuleInstaller(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    AgentBuilder install(InstrumentationModule instrumentationModule, AgentBuilder parentAgentBuilder) {
        if (!AgentConfig.get().isInstrumentationEnabled(instrumentationModule.instrumentationNames(), instrumentationModule.defaultEnabled())) {
            logger.log(Level.FINE, "Instrumentation {0} is disabled", (Object)instrumentationModule.instrumentationName());
            return parentAgentBuilder;
        }
        List helperClassNames = InstrumentationModuleMuzzle.getHelperClassNames((InstrumentationModule)instrumentationModule);
        HelperResourceBuilderImpl helperResourceBuilder = new HelperResourceBuilderImpl();
        instrumentationModule.registerHelperResources((HelperResourceBuilder)helperResourceBuilder);
        List typeInstrumentations = instrumentationModule.typeInstrumentations();
        if (typeInstrumentations.isEmpty()) {
            if (!helperClassNames.isEmpty() || !helperResourceBuilder.getResources().isEmpty()) {
                logger.log(Level.WARNING, "Helper classes and resources won't be injected if no types are instrumented: {0}", (Object)instrumentationModule.instrumentationName());
            }
            return parentAgentBuilder;
        }
        ElementMatcher.Junction moduleClassLoaderMatcher = instrumentationModule.classLoaderMatcher();
        MuzzleMatcher muzzleMatcher = new MuzzleMatcher(instrumentationModule);
        HelperInjector helperInjector = new HelperInjector(instrumentationModule.instrumentationName(), helperClassNames, helperResourceBuilder.getResources(), Utils.getExtensionsClassLoader(), this.instrumentation);
        VirtualFieldImplementationInstaller contextProvider = this.virtualFieldInstallerFactory.create(instrumentationModule);
        AgentBuilder agentBuilder = parentAgentBuilder;
        for (TypeInstrumentation typeInstrumentation : typeInstrumentations) {
            NamedMatcher<TypeDescription> typeMatcher = new NamedMatcher<TypeDescription>(instrumentationModule.getClass().getSimpleName() + "#" + typeInstrumentation.getClass().getSimpleName(), new IgnoreFailedTypeMatcher((ElementMatcher<TypeDescription>)typeInstrumentation.typeMatcher()));
            NamedMatcher classLoaderMatcher = new NamedMatcher(instrumentationModule.getClass().getSimpleName() + "#" + typeInstrumentation.getClass().getSimpleName(), moduleClassLoaderMatcher.and(typeInstrumentation.classLoaderOptimization()));
            AgentBuilder.Identified.Extendable extendableAgentBuilder = ((AgentBuilder.Identified.Narrowable)((AgentBuilder.Identified.Narrowable)agentBuilder.type(new LoggingFailSafeMatcher<TypeDescription>(typeMatcher, "Instrumentation type matcher unexpected exception: " + typeMatcher), new LoggingFailSafeMatcher(classLoaderMatcher, "Instrumentation class loader matcher unexpected exception: " + classLoaderMatcher)).and(NOT_DECORATOR_MATCHER)).and((AgentBuilder.RawMatcher)muzzleMatcher)).transform(ConstantAdjuster.instance()).transform((AgentBuilder.Transformer)helperInjector);
            extendableAgentBuilder = contextProvider.rewriteVirtualFieldsCalls(extendableAgentBuilder);
            TypeTransformerImpl typeTransformer = new TypeTransformerImpl(extendableAgentBuilder);
            typeInstrumentation.transform((TypeTransformer)typeTransformer);
            extendableAgentBuilder = typeTransformer.getAgentBuilder();
            extendableAgentBuilder = contextProvider.injectFields(extendableAgentBuilder);
            agentBuilder = extendableAgentBuilder;
        }
        return agentBuilder;
    }

    private static class MuzzleMatcher
    implements AgentBuilder.RawMatcher {
        private final InstrumentationModule instrumentationModule;
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private final Cache<ClassLoader, Boolean> matchCache = Cache.weak();
        private volatile ReferenceMatcher referenceMatcher;

        private MuzzleMatcher(InstrumentationModule instrumentationModule) {
            this.instrumentationModule = instrumentationModule;
        }

        public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
            if (classLoader == ClassLoadingStrategy.BOOTSTRAP_LOADER) {
                classLoader = Utils.getBootstrapProxy();
            }
            return (Boolean)this.matchCache.computeIfAbsent((Object)classLoader, this::doesMatch);
        }

        private boolean doesMatch(ClassLoader classLoader) {
            ReferenceMatcher muzzle = this.getReferenceMatcher();
            boolean isMatch = muzzle.matches(classLoader);
            if (!isMatch) {
                MuzzleFailureCounter.inc();
                if (muzzleLogger.isLoggable(Level.WARNING)) {
                    muzzleLogger.log(Level.WARNING, "Instrumentation skipped, mismatched references were found: {0} [class {1}] on {2}", new Object[]{this.instrumentationModule.instrumentationName(), this.instrumentationModule.getClass().getName(), classLoader});
                    List mismatches = muzzle.getMismatchedReferenceSources(classLoader);
                    for (Mismatch mismatch : mismatches) {
                        muzzleLogger.log(Level.WARNING, "-- {0}", mismatch);
                    }
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Applying instrumentation: {0} [class {1}] on {2}", new Object[]{this.instrumentationModule.instrumentationName(), this.instrumentationModule.getClass().getName(), classLoader});
            }
            return isMatch;
        }

        private ReferenceMatcher getReferenceMatcher() {
            if (this.initialized.compareAndSet(false, true)) {
                this.referenceMatcher = ReferenceMatcher.of((InstrumentationModule)this.instrumentationModule);
            }
            return this.referenceMatcher;
        }
    }
}

