/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import io.opentelemetry.instrumentation.api.config.Config;

public final class AgentConfig {
    private static final AgentConfig instance = new AgentConfig(Config.get());
    private final Config config;

    public static AgentConfig get() {
        return instance;
    }

    public AgentConfig(Config config) {
        this.config = config;
    }

    public boolean isInstrumentationEnabled(Iterable<String> instrumentationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : instrumentationNames) {
            String propertyName = "otel.instrumentation." + name + ".enabled";
            boolean enabled = this.config.getBoolean(propertyName, defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= enabled;
                continue;
            }
            anyEnabled |= enabled;
        }
        return anyEnabled;
    }

    public boolean isDebugModeEnabled() {
        return this.config.getBoolean("otel.javaagent.debug", false);
    }
}

