/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.matcher;

import io.opentelemetry.javaagent.spi.IgnoreMatcherProvider;
import io.opentelemetry.javaagent.tooling.matcher.AdditionalLibraryIgnoresMatcher;
import java.util.regex.Pattern;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;

public class GlobalIgnoresMatcher
extends ElementMatcher.Junction.AbstractBase<TypeDescription> {
    private static final Pattern COM_MCHANGE_PROXY = Pattern.compile("com\\.mchange\\.v2\\.c3p0\\..*Proxy");
    private final ElementMatcher<TypeDescription> additionalLibraryIgnoreMatcher = AdditionalLibraryIgnoresMatcher.additionalLibraryIgnoresMatcher();
    private final boolean additionalLibraryMatcher;
    private final IgnoreMatcherProvider ignoreMatcherProvider;

    public static ElementMatcher.Junction<TypeDescription> globalIgnoresMatcher(boolean additionalLibraryMatcher, IgnoreMatcherProvider ignoreMatcherProviders) {
        return new GlobalIgnoresMatcher(additionalLibraryMatcher, ignoreMatcherProviders);
    }

    private GlobalIgnoresMatcher(boolean additionalLibraryMatcher, IgnoreMatcherProvider ignoreMatcherProvider) {
        this.additionalLibraryMatcher = additionalLibraryMatcher;
        this.ignoreMatcherProvider = ignoreMatcherProvider;
    }

    public boolean matches(TypeDescription target) {
        IgnoreMatcherProvider.Result ignoreResult = this.ignoreMatcherProvider.type(target);
        switch (ignoreResult) {
            case IGNORE: {
                return true;
            }
            case ALLOW: {
                return false;
            }
        }
        String name = target.getActualName();
        if (name.startsWith("jdk.internal.net.http.")) {
            return false;
        }
        if (name.startsWith("org.gradle.") || name.startsWith("net.bytebuddy.") || name.startsWith("jdk.") || name.startsWith("org.aspectj.") || name.startsWith("datadog.") || name.startsWith("com.intellij.rt.debugger.") || name.startsWith("com.p6spy.") || name.startsWith("com.dynatrace.") || name.startsWith("com.jloadtrace.") || name.startsWith("com.appdynamics.") || name.startsWith("com.newrelic.agent.") || name.startsWith("com.newrelic.api.agent.") || name.startsWith("com.nr.agent.") || name.startsWith("com.singularity.") || name.startsWith("com.jinspired.") || name.startsWith("org.jinspired.")) {
            return true;
        }
        if (name.startsWith("org.groovy.") || name.startsWith("org.apache.groovy.")) {
            return true;
        }
        if (name.startsWith("org.codehaus.groovy.")) {
            return !name.startsWith("org.codehaus.groovy.runtime.");
        }
        if (name.startsWith("clojure.") || name.contains("$fn__")) {
            return true;
        }
        if (name.startsWith("io.opentelemetry.javaagent.")) {
            return !name.equals("io.opentelemetry.javaagent.instrumentation.api.concurrent.RunnableWrapper") && !name.equals("io.opentelemetry.javaagent.instrumentation.api.concurrent.CallableWrapper");
        }
        if (name.startsWith("java.")) {
            if (name.equals("java.net.URL") || name.equals("java.net.HttpURLConnection") || name.equals("java.net.URLClassLoader")) {
                return false;
            }
            if (name.startsWith("java.rmi.") || name.startsWith("java.util.concurrent.")) {
                return false;
            }
            if (name.equals("java.lang.reflect.Proxy")) {
                return false;
            }
            if (name.equals("java.lang.ClassLoader")) {
                return false;
            }
            return !name.startsWith("java.util.logging.") || name.equals("java.util.logging.LogManager$Cleaner");
        }
        if (name.startsWith("com.sun.")) {
            return !name.startsWith("com.sun.messaging.") && !name.startsWith("com.sun.jersey.api.client") && !name.startsWith("com.sun.appserv") && !name.startsWith("com.sun.faces") && !name.startsWith("com.sun.xml.ws");
        }
        if (name.startsWith("sun.")) {
            return !name.startsWith("sun.net.www.protocol.") && !name.startsWith("sun.rmi.server") && !name.startsWith("sun.rmi.transport") && !name.equals("sun.net.www.http.HttpClient");
        }
        if (name.startsWith("org.slf4j.")) {
            return !name.equals("org.slf4j.MDC");
        }
        if (name.contains("$$")) {
            return !name.contains("$$anon$");
        }
        if (name.contains("$JaxbAccessor") || name.contains("CGLIB$$") || name.contains("javassist") || name.contains(".asm.") || name.contains("$__sisu") || name.contains("$$EnhancerByProxool$$") || name.startsWith("org.springframework.core.$Proxy")) {
            return true;
        }
        if (COM_MCHANGE_PROXY.matcher(name).matches()) {
            return true;
        }
        return this.additionalLibraryMatcher && this.additionalLibraryIgnoreMatcher.matches((Object)target);
    }

    public String toString() {
        return "globalIgnoresMatcher(" + this.additionalLibraryIgnoreMatcher.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GlobalIgnoresMatcher)) {
            return false;
        }
        GlobalIgnoresMatcher other = (GlobalIgnoresMatcher)((Object)obj);
        return this.additionalLibraryIgnoreMatcher.equals(other.additionalLibraryIgnoreMatcher);
    }

    public int hashCode() {
        return this.additionalLibraryIgnoreMatcher.hashCode();
    }
}

