/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.matcher;

import io.opentelemetry.javaagent.bootstrap.WeakCache;
import io.opentelemetry.javaagent.tooling.AgentTooling;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationClassPredicate;
import io.opentelemetry.javaagent.tooling.muzzle.Reference;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.HelperReferenceWrapper;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.Mismatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.pool.TypePool;

public final class ReferenceMatcher {
    private final WeakCache<ClassLoader, Boolean> mismatchCache = AgentTooling.newWeakCache();
    private final Map<String, Reference> references;
    private final Set<String> helperClassNames;

    public ReferenceMatcher(Reference ... references) {
        this(Collections.emptyList(), references);
    }

    public ReferenceMatcher(List<String> helperClassNames, Reference[] references) {
        this.references = new HashMap<String, Reference>(references.length);
        for (Reference reference : references) {
            this.references.put(reference.getClassName(), reference);
        }
        this.helperClassNames = new HashSet<String>(helperClassNames);
    }

    Collection<Reference> getReferences() {
        return this.references.values();
    }

    public boolean matches(ClassLoader userClassLoader) {
        if (userClassLoader == ClassLoadingStrategy.BOOTSTRAP_LOADER) {
            userClassLoader = Utils.getBootstrapProxy();
        }
        ClassLoader cl = userClassLoader;
        return (Boolean)this.mismatchCache.getIfPresentOrCompute((Object)userClassLoader, () -> this.doesMatch(cl));
    }

    private boolean doesMatch(ClassLoader loader) {
        for (Reference reference : this.references.values()) {
            if (this.checkMatch(reference, loader).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<Mismatch> getMismatchedReferenceSources(ClassLoader loader) {
        if (loader == ClassLoadingStrategy.BOOTSTRAP_LOADER) {
            loader = Utils.getBootstrapProxy();
        }
        List<Mismatch> mismatches = Collections.emptyList();
        for (Reference reference : this.references.values()) {
            mismatches = ReferenceMatcher.lazyAddAll(mismatches, this.checkMatch(reference, loader));
        }
        return mismatches;
    }

    private List<Mismatch> checkMatch(Reference reference, ClassLoader loader) {
        TypePool typePool = AgentTooling.poolStrategy().typePool(AgentTooling.locationStrategy().classFileLocator(loader), loader);
        try {
            if (InstrumentationClassPredicate.isInstrumentationClass(reference.getClassName())) {
                if (!this.helperClassNames.contains(reference.getClassName())) {
                    return Collections.singletonList(new Mismatch.MissingClass(reference.getSources().toArray(new Reference.Source[0]), reference.getClassName()));
                }
                return this.checkHelperClassMatch(reference, typePool);
            }
            if (this.helperClassNames.contains(reference.getClassName())) {
                return Collections.emptyList();
            }
            TypePool.Resolution resolution = typePool.describe(reference.getClassName());
            if (!resolution.isResolved()) {
                return Collections.singletonList(new Mismatch.MissingClass(reference.getSources().toArray(new Reference.Source[0]), reference.getClassName()));
            }
            return ReferenceMatcher.checkThirdPartyTypeMatch(reference, resolution.resolve());
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("Cannot resolve type description for ")) {
                String className = e.getMessage().replace("Cannot resolve type description for ", "");
                return Collections.singletonList(new Mismatch.MissingClass(reference.getSources().toArray(new Reference.Source[0]), className));
            }
            return Collections.singletonList(new Mismatch.ReferenceCheckError(e, reference, loader));
        }
    }

    private List<Mismatch> checkHelperClassMatch(Reference helperClass, TypePool typePool) {
        List<Mismatch> mismatches = Collections.emptyList();
        HelperReferenceWrapper helperWrapper = new HelperReferenceWrapper.Factory(typePool, this.references).create(helperClass);
        if (!helperWrapper.hasSuperTypes() || helperWrapper.isAbstract()) {
            return mismatches;
        }
        HashSet<HelperReferenceWrapper.Method> abstractMethods = new HashSet<HelperReferenceWrapper.Method>();
        HashSet<HelperReferenceWrapper.Method> plainMethods = new HashSet<HelperReferenceWrapper.Method>();
        ReferenceMatcher.collectMethodsFromTypeHierarchy(helperWrapper, abstractMethods, plainMethods);
        abstractMethods.removeAll(plainMethods);
        for (HelperReferenceWrapper.Method unimplementedMethod : abstractMethods) {
            mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingMethod(helperClass.getSources().toArray(new Reference.Source[0]), unimplementedMethod.getDeclaringClass(), unimplementedMethod.getName(), unimplementedMethod.getDescriptor()));
        }
        return mismatches;
    }

    private static void collectMethodsFromTypeHierarchy(HelperReferenceWrapper type, Set<HelperReferenceWrapper.Method> abstractMethods, Set<HelperReferenceWrapper.Method> plainMethods) {
        type.getMethods().forEach(method -> (method.isAbstract() ? abstractMethods : plainMethods).add(method));
        type.getSuperTypes().forEach(superType -> ReferenceMatcher.collectMethodsFromTypeHierarchy(superType, abstractMethods, plainMethods));
    }

    private static List<Mismatch> checkThirdPartyTypeMatch(Reference reference, TypeDescription typeOnClasspath) {
        String desc;
        List<Mismatch> mismatches = Collections.emptyList();
        for (Reference.Flag flag : reference.getFlags()) {
            if (flag.matches(typeOnClasspath.getActualModifiers(false))) continue;
            String desc2 = reference.getClassName();
            mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingFlag(reference.getSources().toArray(new Reference.Source[0]), desc2, flag, typeOnClasspath.getActualModifiers(false)));
        }
        for (Reference.Field fieldRef : reference.getFields()) {
            FieldDescription.InDefinedShape fieldDescription = ReferenceMatcher.findField(fieldRef, typeOnClasspath);
            if (fieldDescription == null) {
                mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingField(fieldRef.getSources().toArray(new Reference.Source[0]), reference.getClassName(), fieldRef.getName(), fieldRef.getType().getInternalName()));
                continue;
            }
            for (Reference.Flag flag : fieldRef.getFlags()) {
                if (flag.matches(fieldDescription.getModifiers())) continue;
                desc = reference.getClassName() + "#" + fieldRef.getName() + fieldRef.getType().getInternalName();
                mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingFlag(fieldRef.getSources().toArray(new Reference.Source[0]), desc, flag, fieldDescription.getModifiers()));
            }
        }
        for (Reference.Method methodRef : reference.getMethods()) {
            MethodDescription.InDefinedShape methodDescription = ReferenceMatcher.findMethod(methodRef, typeOnClasspath);
            if (methodDescription == null) {
                mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingMethod(methodRef.getSources().toArray(new Reference.Source[0]), reference.getClassName(), methodRef.getName(), methodRef.getDescriptor()));
                continue;
            }
            for (Reference.Flag flag : methodRef.getFlags()) {
                if (flag.matches(methodDescription.getModifiers())) continue;
                desc = reference.getClassName() + "#" + methodRef.getName() + methodRef.getDescriptor();
                mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingFlag(methodRef.getSources().toArray(new Reference.Source[0]), desc, flag, methodDescription.getModifiers()));
            }
        }
        return mismatches;
    }

    private static boolean matchesPrimitive(String longName, String shortName) {
        return shortName.equals("I") && longName.equals(Integer.TYPE.getName()) || shortName.equals("C") && longName.equals(Character.TYPE.getName()) || shortName.equals("Z") && longName.equals(Boolean.TYPE.getName()) || shortName.equals("J") && longName.equals(Long.TYPE.getName()) || shortName.equals("S") && longName.equals(Short.TYPE.getName()) || shortName.equals("F") && longName.equals(Float.TYPE.getName()) || shortName.equals("D") && longName.equals(Double.TYPE.getName()) || shortName.equals("B") && longName.equals(Byte.TYPE.getName());
    }

    private static FieldDescription.InDefinedShape findField(Reference.Field fieldRef, TypeDescription typeOnClasspath) {
        FieldDescription.InDefinedShape fieldOnSupertype;
        for (FieldDescription.InDefinedShape fieldType : typeOnClasspath.getDeclaredFields()) {
            if (!fieldType.getName().equals(fieldRef.getName()) || !fieldType.getType().asErasure().getInternalName().equals(fieldRef.getType().getInternalName()) && (!fieldType.getType().asErasure().isPrimitive() || !ReferenceMatcher.matchesPrimitive(fieldType.getType().asErasure().getInternalName(), fieldRef.getType().getInternalName()))) continue;
            return fieldType;
        }
        if (typeOnClasspath.getSuperClass() != null && (fieldOnSupertype = ReferenceMatcher.findField(fieldRef, typeOnClasspath.getSuperClass().asErasure())) != null) {
            return fieldOnSupertype;
        }
        for (TypeDescription.Generic interfaceType : typeOnClasspath.getInterfaces()) {
            FieldDescription.InDefinedShape fieldOnSupertype2 = ReferenceMatcher.findField(fieldRef, interfaceType.asErasure());
            if (fieldOnSupertype2 == null) continue;
            return fieldOnSupertype2;
        }
        return null;
    }

    private static MethodDescription.InDefinedShape findMethod(Reference.Method methodRef, TypeDescription typeOnClasspath) {
        MethodDescription.InDefinedShape methodOnSupertype;
        for (MethodDescription.InDefinedShape methodDescription : typeOnClasspath.getDeclaredMethods()) {
            if (!methodDescription.getInternalName().equals(methodRef.getName()) || !methodDescription.getDescriptor().equals(methodRef.getDescriptor())) continue;
            return methodDescription;
        }
        if (typeOnClasspath.getSuperClass() != null && (methodOnSupertype = ReferenceMatcher.findMethod(methodRef, typeOnClasspath.getSuperClass().asErasure())) != null) {
            return methodOnSupertype;
        }
        for (TypeDescription.Generic interfaceType : typeOnClasspath.getInterfaces()) {
            MethodDescription.InDefinedShape methodOnSupertype2 = ReferenceMatcher.findMethod(methodRef, interfaceType.asErasure());
            if (methodOnSupertype2 == null) continue;
            return methodOnSupertype2;
        }
        return null;
    }

    private static List<Mismatch> lazyAdd(List<Mismatch> mismatches, Mismatch mismatch) {
        ArrayList<Mismatch> result = mismatches.isEmpty() ? new ArrayList<Mismatch>() : mismatches;
        result.add(mismatch);
        return result;
    }

    private static List<Mismatch> lazyAddAll(List<Mismatch> mismatches, List<Mismatch> toAdd) {
        if (!toAdd.isEmpty()) {
            ArrayList<Mismatch> result = mismatches.isEmpty() ? new ArrayList<Mismatch>() : mismatches;
            result.addAll(toAdd);
            return result;
        }
        return mismatches;
    }
}

